# -*- coding: UTF-8 -*-
"""Timer related classes"""
import blindstation.cblind
from blindstation.utils import BSCError, BSError, WeakMethod
import weakref

class Timer(object):
    """A Timer is a useful widget to measure time"""

    def __init__(self, scene, name):
        "A timer must be initialised with its name"
        if len(name) <= 0:
            raise NameError, 'Timer name'
        self.name = name
        self.id = scene.register_timer(self)
        self.ctimer = blindstation.cblind.CTimer_init(self.id)
        if self.ctimer is None:
            raise BSCError, 'CTimer_init failed'
        self.scene = weakref.ref(scene)
        self.__timer_callback__ = None

    def __del__(self):
        "Timer destructor"
        if blindstation.cblind.CTimer_del(self.ctimer) == 0:
            raise BSCError, 'CTimer_del failed'

    def setTime(self, time):
        "Set the length of the timer and launch it"
        if blindstation.cblind.CTimer_setTime(self.ctimer, time) == 0:
            raise BSCError, 'CTimer_setTime failed'

    def set_timer_callback(self, callback):
        if callback is None:
            self.__timer_callback__ = None
        else:
            self.__timer_callback__ = WeakMethod(callback)

    def get_timer_callback(self):
        if self.__timer_callback__ is None:
            return None
        callback = self.__timer_callback__()
        if callback is None:
            raise BSError, "the timer callback has been garbage collected"
        return callback

    timer_callback = property(get_timer_callback, set_timer_callback, None,
                        "Callback to be called when the timer is triggered")
