from msobjects import Monster, MonsterBoss, BonusObject, MonsterLevel

#-- ----------------------------------------------------
levels={}
monsterList={}
bossList={}
bonusList={}

# Normal level list
levelliste1=['L1','L2','L3','L4','L5','L6','L7','L8','L9','L10','L11','L12','L13','L14','L15','L16','L17','L18','L19','L20','L21','L22','L23','L24','L25']

# Level list for limited time game
levelliste2=['L5']

# Level list for testing end game
levelliste3=['L16', 'L17', 'L18', 'L19']

# Bonus level list
levelliste4=['L10bonus','L15bonus','L20bonus','L25']


#-- ----------------------------------------------------
# Values between 0 and 100
initBackgroundVolume=100
initEventsVolume=100
initMonstersVolume=100
initMasterVolume=90

#-- ----------------------------------------------------

monsterList['monster11']=Monster('monster11', cat=1, rep='a')
monsterList['monster12']=Monster('monster12', cat=1, rep='b')
monsterList['monster13']=Monster('monster13', cat=1, rep='c')
monsterList['monster14']=Monster('monster14', cat=1, rep='d')
monsterList['monster15']=Monster('monster15', cat=1, rep='e')
monsterList['monster16']=Monster('monster16', cat=1, rep='f')
monsterList['monster17']=Monster('monster17', cat=1, rep='g')
monsterList['monster18']=Monster('monster18', cat=1, rep='h')
monsterList['monster19']=Monster('monster19', cat=1, rep='i')
monsterList['monster21']=Monster('monster21', cat=2, rep='j')
monsterList['monster22']=Monster('monster22', cat=2, rep='k')
monsterList['monster23']=Monster('monster23', cat=2, rep='l')
monsterList['monster24']=Monster('monster24', cat=2, rep='m')
monsterList['monster25']=Monster('monster25', cat=2, rep='n')
monsterList['monster26']=Monster('monster26', cat=2, rep='o')
monsterList['monster27']=Monster('monster27', cat=2, rep='p')
monsterList['monster31']=Monster('monster31', cat=3, rep='q')
monsterList['monster32']=Monster('monster32', cat=3, rep='r')
monsterList['monster33']=Monster('monster33', cat=3, rep='s')
monsterList['monster34']=Monster('monster34', cat=3, rep='t')
monsterList['monster35']=Monster('monster35', cat=3, rep='u')
monsterList['monster36']=Monster('monster36', cat=3, rep='v')

monsterList['+bounce1']=Monster('+bounce1', cat=11, rep='1')
monsterList['+bounce2']=Monster('+bounce2', cat=11, rep='2')
monsterList['+bounce3']=Monster('+bounce3', cat=11, rep='3')
monsterList['+bounce4']=Monster('+bounce4', cat=11, rep='4')
monsterList['+bounce5']=Monster('+bounce5', cat=11, rep='5')
monsterList['+bounce5']=Monster('+bounce5', cat=11, rep='5')
monsterList['+bounce6']=Monster('+bounce6', cat=11, rep='6')
monsterList['+bounce7']=Monster('+bounce7', cat=11, rep='7')
monsterList['-bounce1']=Monster('-bounce1', cat=12, rep='-')
monsterList['-bounce2']=Monster('-bounce2', cat=12, rep='_')

#-- ----------------------------------------------------
bonusList['EL']=BonusObject(
  name='Extra life',
  kind='EL',
  score=0,
  rep='!',
  bounce='bonus',
  hitwav='extralifehit'
  )

bonusList['ELH']=BonusObject(
  name='Extra life hidden',
  kind='EL',
  score=0,
  rep='|',
  bounce='+bounce2',
  hitwav='extralifehit'
  )

bonusList['EP']=BonusObject(
  name='Extra points',
  kind='EP',
  score=20,
  rep='.',
  bounce='bonus',
  hitwav='pointshit'
  )

bonusList['B']=BonusObject(
  name='Bomb',
  kind='B',
  score=0,
  rep='*',
  bounce='bonus',
  hitwav='bombhit'
  )

bonusList['UW']=BonusObject(
  name='Unlimited water',
  kind='UW',
  score=0,
  rep='%',
  bounce='bonus',
  hitwav='uwaterhit'
  )

bonusList['SM']=BonusObject(
  name='Score multiplier',
  kind='SM',
  score=0,
  rep='$',
  bounce='bonus',
  hitwav='doublemscorehit'
  )

bonusList['BL']=BonusObject(
  name='Bonus level object',
  kind='BL',
  score=0,
  rep='@',
  bounce='bonuslo',
  hitwav='bonuslevelobjhit'
  )

#-- ----------------------------------------------------

bossList['boss01']=MonsterBoss(
  name='boss01',
  width=3,
  score=50,
  speed=2,
  moveDist=2,
  probaToFire=40,
  probaToTurn=20,
  fireAgain=3,
  hitsToDie=3,
  rep='A',
  avoidPlayer=1,
  wavbase='boss1'
  )

bossList['boss02']=MonsterBoss(
  name='boss02',
  width=2,
  score=100,
  speed=2,
  moveDist=2,
  probaToFire=55,
  probaToTurn=30,
  fireAgain=1,
  hitsToDie=5,
  rep='A',
  avoidPlayer=1,
  wavbase='boss2'
  )


bossList['boss03']=MonsterBoss(
  name='boss03',
  width=2,
  score=150,
  speed=3,
  moveDist=1,
  probaToFire=70,
  probaToTurn=40,
  fireAgain=1,
  hitsToDie=7,
  rep='A',
  avoidPlayer=1,
  wavbase='boss3'
  )

bossList['boss04']=MonsterBoss(
  name='boss04',
  width=2,
  score=200,
  speed=3,
  moveDist=2,
  probaToFire=80,
  probaToTurn=40,
  fireAgain=0,
  hitsToDie=9,
  rep='A',
  avoidPlayer=1,
  wavbase='boss4'
  )

bossList['boss05']=MonsterBoss(
  name='boss05',
  width=3,
  score=100,
  speed=4,
  moveDist=1,
  probaToFire=90,
  probaToTurn=40,
  fireAgain=0,
  hitsToDie=3,
  rep='A',
  avoidPlayer=1,
  wavbase='boss3'
  )

# when killed, boss5 becomes boss6

bossList['boss06']=MonsterBoss(
  name='boss06',
  width=2,
  score=200,
  speed=4,
  moveDist=1,
  probaToFire=90,
  probaToTurn=40,
  fireAgain=0,
  hitsToDie=4,
  rep='A',
  avoidPlayer=1,
  wavbase='boss6'
  )

# when killed, boss6 becomes boss7

bossList['boss07']=MonsterBoss(
  name='boss07',
  width=1,
  score=500,
  speed=4,
  moveDist=1,
  probaToFire=90,
  probaToTurn=40,
  fireAgain=0,
  hitsToDie=5,
  rep='A',
  avoidPlayer=1,
  wavbase='boss7'
  )



#-- ----------------------------------------------------

#new params:
#
#  waterContainerSize  (default value=5)
#  --> Maximum number of units in the water container
#
#  waterRefillUnits    (default value=1)
#  --> Number of units to refill each time unit
#
#  waterRefillDelay    (default value=2)
#  --> Number of time units between water refills
#

levels['L1']=MonsterLevel(
  name='machineroom1',
  world='machineroom',
  levelnum='level1',
  width=15,
  waterContainerSize=5, 
  nbMaxMonsters=1,
  probaMonsterAppears=80,
  probaBonus=0,
  monsterMaxWait=7,
  monsterDelayToFire=15,
  mudwidth=1,
  throw='1250',
  bgsound='machineroom1',
  nbtokill=6,
  scoreMult=1,
  tempo=2000,
  monsters=['monster31','monster32','monster33','monster34'],
  bonus=[]
  )

levels['L2']=MonsterLevel(
  name='machineroom2',
  world='machineroom',
  levelnum='level2',
  width=15,
  waterContainerSize=5, 
  nbMaxMonsters=1,
  probaMonsterAppears=90,
  probaBonus=10,
  monsterMaxWait=5,
  monsterDelayToFire=14,
  mudwidth=1,
  throw='1250',
  bgsound='machineroom2',
  nbtokill=8,
  scoreMult=1,
  tempo=1900,
  monsters=['monster31','monster32','monster33','monster34','monster35'],
  bonus=[('EP',1),('BL',1)]
  )

levels['L3']=MonsterLevel(
  name='machineroom3',
  world='machineroom',
  levelnum='level3',
  width=15,
  waterContainerSize=5, 
  nbMaxMonsters=2,
  probaMonsterAppears=10,
  probaMonster1Appears=90,
  probaBonus=10,
  monsterMaxWait=4,
  monsterDelayToFire=13,
  mudwidth=1,
  throw='1250',
  bgsound='machineroom3',
  nbtokill=10,
  scoreMult=1,
  tempo=1800,
  monsters=['monster32','monster33','monster34','monster36','monster21'],
  bonus=[('SM',1),('BL',1)]
  )

levels['L4']=MonsterLevel(
  name='machineroom4',
  world='machineroom',
  levelnum='level4',
  width=15,
  waterContainerSize=5, 
  nbMaxMonsters=2,
  probaMonsterAppears=20,
  probaMonster1Appears=90,
  probaBonus=15,
  monsterMaxWait=4,
  monsterDelayToFire=12,
  mudwidth=1,
  throw='1250',
  bgsound='machineroom4',
  nbtokill=11,
  scoreMult=1,
  tempo=1700,
  monsters=['monster31','monster32','monster33','monster34','monster22'],
  bonus=[('EP',1),('B',1),('EL',1),('BL',1)]
  )

levels['L5']=MonsterLevel(
  name='machineroom5',
  world='machineroom',
  levelnum='level5',
  width=15,
  waterContainerSize=5, 
  nbMaxMonsters=2,
  probaMonsterAppears=40,
  probaMonster1Appears=90,
  probaBonus=15,
  monsterMaxWait=3,
  monsterDelayToFire=10,
  mudwidth=1,
  throw='1250',
  bgsound='machineroom5',
  nbtokill=12,
  scoreMult=1,
  tempo=1600,
  monsters=['monster33','monster34','monster35','monster36','monster21','monster22'],
  bossMonster=['boss01'],
  bgsoundBoss='machineroomboss',
  sonix='sonix01',
  bonus=[('B',1),('SM',1),('BL',1)]
  )

levels['L6']=MonsterLevel(
  name='chemmine1',
  world='chemind',
  levelnum='level1',
  width=15,
  waterContainerSize=4, 
  nbMaxMonsters=2,
  probaMonsterAppears=20,
  probaMonster1Appears=80,
  probaBonus=15,
  monsterMaxWait=3,
  monsterDelayToFire=12,
  mudwidth=1,
  throw='1000A',
  bgsound='nychem1',
  nbtokill=10,
  scoreMult=2,
  tempo=1800,
  monsters=['monster34','monster35','monster36','monster22','monster23'],
  bonus=[('EP',1),('SM',1)]
  )

levels['L7']=MonsterLevel(
  name='chemmine2',
  world='chemind',
  levelnum='level2',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=2,
  probaMonsterAppears=40,
  probaMonster1Appears=80,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=11,
  mudwidth=1,
  throw='1000A',
  bgsound='nychem2',
  nbtokill=12,
  scoreMult=2,
  tempo=1700,
  monsters=['monster32','monster33','monster21','monster23','monster24'],
  bonus=[('EP',1),('UW',1),('BL',1)]
  )

levels['L8']=MonsterLevel(
  name='chemmine3',
  world='chemind',
  levelnum='level3',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=3,
  probaMonsterAppears=10,
  probaMonster1Appears=80,
  probaMonster2Appears=40,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=10,
  mudwidth=1,
  throw='1000A',
  bgsound='nychem3',
  nbtokill=13,
  scoreMult=2,
  tempo=1600,
  monsters=['monster31','monster21','monster22','monster23','monster24','monster11'],
  bonus=[('SM',1),('B',1),('EL',1),('BL',1)]
  )

levels['L9']=MonsterLevel(
  name='chemmine4',
  world='chemind',
  levelnum='level4',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=3,
  probaMonsterAppears=20,
  probaMonster1Appears=90,
  probaMonster2Appears=40,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=9,
  mudwidth=1,
  throw='1000A',
  bgsound='nychem4',
  nbtokill=14,
  scoreMult=2,
  tempo=1500,
  monsters=['monster36','monster23','monster24','monster25','monster26','monster12'],
  bonus=[('UW',1),('B',1),('BL',1)]
  )

levels['L10']=MonsterLevel(
  name='chemmine5',
  world='chemind',
  levelnum='level5',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=3,
  probaMonsterAppears=20,
  probaMonster1Appears=90,
  probaMonster2Appears=50,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=8,
  mudwidth=1,
  throw='1000A',
  bgsound='nychem5',
  nbtokill=14,
  scoreMult=2,
  tempo=1400,
  monsters=['monster35','monster23','monster24','monster25','monster26','monster13'],
  bossMonster=['boss02'],
  bgsoundBoss='nychemboss',
  sonix='sonix02',

  bonus=[('UW',1),('B',2),('SM',1),('BL',1)]
  )

levels['L11']=MonsterLevel(
  name='power1',
  world='power',
  levelnum='level1',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=2,
  probaMonsterAppears=20,
  probaMonster1Appears=80,
  probaBonus=15,
  monsterMaxWait=3,
  monsterDelayToFire=10,
  mudwidth=2,
  throw='1000B',
  bgsound='power1',
  nbtokill=12,
  scoreMult=3,
  tempo=1600,
  monsters=['monster34','monster21','monster22','monster23','monster13','monster14'],
  bonus=[('EP',1),('UW',2)]
  )

levels['L12']=MonsterLevel(
  name='power2',
  world='power',
  levelnum='level2',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=3,
  probaMonsterAppears=10,
  probaMonster1Appears=90,
  probaMonster2Appears=30,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=9,
  mudwidth=2,
  throw='1000B',
  bgsound='power2',
  nbtokill=13,
  scoreMult=3,
  tempo=1500,
  monsters=['monster33','monster23','monster24','monster12','monster13','monster14'],
  bonus=[('SM',1),('B',1),('EL',1),('BL',1)]
  )

levels['L13']=MonsterLevel(
  name='power3',
  world='power',
  levelnum='level3',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=3,
  probaMonsterAppears=20,
  probaMonster1Appears=90,
  probaMonster2Appears=40,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=8,
  mudwidth=2,
  throw='1000B',
  bgsound='power3',
  nbtokill=14,
  scoreMult=3,
  tempo=1400,
  monsters=['monster32','monster25','monster26','monster13','monster14','monster15'],
  bonus=[('SM',1),('B',1),('BL',1)]
  )

levels['L14']=MonsterLevel(
  name='power4',
  world='power',
  levelnum='level4',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=3,
  probaMonsterAppears=30,
  probaMonster1Appears=90,
  probaMonster2Appears=50,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=8,
  mudwidth=2,
  throw='1000B',
  bgsound='power4',
  nbtokill=15,
  scoreMult=3,
  tempo=1300,
  monsters=['monster36','monster21','monster22','monster14','monster15'],
  bonus=[('EP',1),('B',1),('EL',1),('UW',1),('BL',1)]
  )

levels['L15']=MonsterLevel(
  name='power5',
  world='power',
  levelnum='level5',
  width=15,
  waterContainerSize=4,
  nbMaxMonsters=3,
  probaMonsterAppears=40,
  probaMonster1Appears=90,
  probaMonster2Appears=50,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=7,
  mudwidth=2,
  throw='1000B',
  bgsound='power5',
  nbtokill=16,
  scoreMult=3,
  tempo=1300,
  monsters=['monster35','monster24','monster25','monster11','monster12','monster13','monster14'],
  bossMonster=['boss03'],
  sonix='sonix03',
  bgsoundBoss='powerboss',
  bonus=[('EP',1),('B',2),('UW',1),('BL',1)]
  )

levels['L16']=MonsterLevel(
  name='toystore1',
  world='toystore',
  levelnum='level1',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=3,
  probaMonsterAppears=20,
  probaMonster1Appears=80,
  probaMonster2Appears=30,
  probaBonus=15,
  monsterMaxWait=3,
  monsterDelayToFire=9,
  mudwidth=2,
  throw='750A',
  bgsound='toystore1',
  nbtokill=14,
  scoreMult=4,
  tempo=1400,
  monsters=['monster34','monster24','monster25','monster26','monster14','monster15','monster16'],
  bonus=[('EP',1),('B',1)]
  )

levels['L17']=MonsterLevel(
  name='toystore2',
  world='toystore',
  levelnum='level2',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=3,
  probaMonsterAppears=20,
  probaMonster1Appears=90,
  probaMonster2Appears=40,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=8,
  mudwidth=2,
  throw='750A',
  bgsound='toystore2',
  nbtokill=15,
  scoreMult=4,
  tempo=1400,
  monsters=['monster21','monster22','monster11','monster13','monster14','monster16'],
  bonus=[('EP',1),('B',1),('SM',1),('BL',1)]
  )

levels['L18']=MonsterLevel(
  name='toystore3',
  world='toystore',
  levelnum='level3',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=3,
  probaMonsterAppears=30,
  probaMonster1Appears=90,
  probaMonster2Appears=50,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=7,
  mudwidth=2,
  throw='750A',
  bgsound='toystore3',
  nbtokill=16,
  scoreMult=4,
  tempo=1300,
  monsters=['monster32','monster23','monster11','monster12','monster13','monster14'],
  bonus=[('UW',1),('B',1),('SM',1),('BL',1)]
  )

levels['L19']=MonsterLevel(
  name='toystore4',
  world='toystore',
  levelnum='level4',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=3,
  probaMonsterAppears=30,
  probaMonster1Appears=90,
  probaMonster2Appears=60,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=6,
  mudwidth=2,
  throw='750A',
  bgsound='toystore4',
  nbtokill=17,
  scoreMult=4,
  tempo=1300,
  monsters=['monster31','monster25','monster24','monster15','monster16','monster17'],
  bonus=[('EL',1),('B',2),('UW',1),('BL',1)]
  )

levels['L20']=MonsterLevel(
  name='toystore5',
  world='toystore',
  levelnum='level5',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=4,
  probaMonsterAppears=30,
  probaMonster1Appears=90,
  probaMonster2Appears=60,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=6,
  mudwidth=2,
  throw='750A',
  bgsound='toystore5',
  nbtokill=18,
  scoreMult=4,
  tempo=1200,
  monsters=['monster26','monster15','monster16','monster17','monster18'],
  bossMonster=['boss04'],
  bgsoundBoss='toystoreboss',
  sonix='sonix04',
  bonus=[('EL',1),('B',2),('UW',1),('SM',1),('BL',1)]
  )

levels['L21']=MonsterLevel(
  name='sewer1',
  world='sewer',
  levelnum='level1',
  width=15,
  waterContainerSize=2,
  nbMaxMonsters=3,
  probaMonsterAppears=30,
  probaMonster1Appears=90,
  probaMonster2Appears=20,
  probaBonus=15,
  monsterMaxWait=2,
  monsterDelayToFire=8,
  mudwidth=3,
  throw='750B',
  bgsound='sewer1',
  nbtokill=16,
  scoreMult=5,
  tempo=1300,
  monsters=['monster22','monster23','monster11','monster12','monster14','monster16'],
  bonus=[('EP',1)]
  )

levels['L22']=MonsterLevel(
  name='sewer2',
  world='sewer',
  levelnum='level2',
  width=15,
  waterContainerSize=2,
  nbMaxMonsters=4,
  probaMonsterAppears=40,
  probaMonster1Appears=90,
  probaMonster2Appears=20,
  probaBonus=15,
  monsterMaxWait=1,
  monsterDelayToFire=7,
  mudwidth=3,
  throw='750B',
  bgsound='sewer2',
  nbtokill=17,
  scoreMult=5,
  tempo=1200,
  monsters=['monster21','monster24','monster13','monster15','monster17','monster18'],
  bonus=[('EL',1),('B',1),('SM',1),('UW',1)]
  )

levels['L23']=MonsterLevel(
  name='sewer3',
  world='sewer',
  levelnum='level3',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=4,
  probaMonsterAppears=50,
  probaMonster1Appears=90,
  probaMonster2Appears=30,
  probaBonus=15,
  monsterMaxWait=1,
  monsterDelayToFire=6,
  mudwidth=2,
  throw='750B',
  bgsound='sewer3',
  nbtokill=18,
  scoreMult=5,
  tempo=1100,
  monsters=['monster21','monster11','monster13','monster15','monster17','monster19'],
  bonus=[('B',1),('EP',1),('UW',1)]
  )

levels['L24']=MonsterLevel(
  name='sewer4',
  world='sewer',
  levelnum='level4',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=4,
  probaMonsterAppears=60,
  probaMonster1Appears=90,
  probaMonster2Appears=40,
  probaBonus=15,
  monsterMaxWait=1,
  monsterDelayToFire=5,
  mudwidth=3,
  throw='750B',
  bgsound='sewer4',
  nbtokill=19,
  scoreMult=5,
  tempo=1100,
  monsters=['monster11','monster12','monster13','monster15','monster16','monster18','monster19'],
  bonus=[('EL',1),('B',1),('SM',1),('UW',1)]
  )

levels['L25']=MonsterLevel(
  name='sewer5',
  world='sewer',
  levelnum='level5',
  width=15,
  waterContainerSize=3,
  nbMaxMonsters=4,
  probaMonsterAppears=50,
  probaMonster1Appears=90,
  probaMonster2Appears=70,
  probaBonus=15,
  monsterMaxWait=1,
  monsterDelayToFire=4,
  mudwidth=2,
  throw='750B',
  bgsound='sewer5',
  nbtokill=20,
  scoreMult=5,
  tempo=1000,
  monsters=['monster11','monster12','monster13','monster14','monster15','monster16','monster17','monster18'],
  bossMonster=['boss05','boss06','boss07'],
  bgsoundBoss='sewerboss',
  sonix='sonix05',
  bonus=[('B',2),('SM',1)]
  )

#-- ----------------------------------------------------
levels['L5bonus']=MonsterLevel(
  name='chemmine5bonus',
  world='bonus',
  levelnum='bonuslevel', # not usefull here but have to be set to something
  width=15,
  waterContainerSize=16,
  waterRefillUnits=2,  
  nbMaxMonsters=4,
  probaMonsterAppears=95,
  probaMonster1Appears=95,
  probaMonster2Appears=95,
  probaBonus=100,
  monsterMaxWait=1,
  monsterDelayToFire=7, # in the case of bonus level,
#  monsterDelayToFire=10, # in the case of bonus level,
                         # it will be the time to disappear
  mudwidth=1, # not usefull here but have to be set to something
  throw='1250', # not usefull here but have to be set to something
  bgsound='bonuslevelbg',
  nbtokill=16,
#  nbtokill=10,
  scoreMult=1,
  tempo=2400,
  monsters=['+bounce1','+bounce2','+bounce3','+bounce4','+bounce5'],
  bonus=[('ELH',1)],
  bonusLevel=1
  )

levels['L10bonus']=MonsterLevel(
  name='machineroom5bonus',
  world='bonus',
  levelnum='bonuslevel', # not usefull here but have to be set to something
  width=15,
  waterContainerSize=18,
  waterRefillUnits=2, 
  nbMaxMonsters=4,
  probaMonsterAppears=95,
  probaMonster1Appears=95,
  probaMonster2Appears=95,
  probaBonus=100, 
  monsterMaxWait=1,
  monsterDelayToFire=6,  # in the case of bonus level,
                         # it will be the time to disappear
  mudwidth=1, # not usefull here but have to be set to something
  throw='1000A', # not usefull here but have to be set to something
  bgsound='bonuslevelbg',
  nbtokill=18,
  scoreMult=2,
  tempo=2400,
  monsters=['-bounce1','+bounce1','+bounce2','+bounce3','+bounce4','+bounce5','+bounce6'],
  bonus=[('ELH',1)],
  bonusLevel=1
  )

levels['L15bonus']=MonsterLevel(
  name='toystore5bonus',
  world='bonus',
  levelnum='bonuslevel', # not usefull here but have to be set to something
  width=15,
  waterContainerSize=20,
  waterRefillUnits=2, 
  nbMaxMonsters=4,
  probaMonsterAppears=95,
  probaMonster1Appears=95,
  probaMonster2Appears=95,
  probaBonus=100,
  monsterMaxWait=1,
  monsterDelayToFire=5, # in the case of bonus level,
                        # it will be the time to disappear
  mudwidth=2, # not usefull here but have to be set to something
  throw='1000B', # not usefull here but have to be set to something
  bgsound='bonuslevelbg',
  nbtokill=20,
  scoreMult=3,
  tempo=2400,
  monsters=['-bounce1','-bounce2','+bounce1','+bounce2','+bounce3','+bounce4','+bounce5','+bounce6','+bounce7'],
  bonus=[('ELH',1)],
  bonusLevel=1
  )

# plus another -bonus object in bonus levels 3 & 4

levels['L20bonus']=MonsterLevel(
  name='power5bonus',
  world='bonus',
  levelnum='bonuslevel', # not usefull here but have to be set to something
  width=15,
  waterContainerSize=22,
  waterRefillUnits=2, 
  nbMaxMonsters=4,
  probaMonsterAppears=95,
  probaMonster1Appears=95,
  probaMonster2Appears=95,
  probaBonus=100, 
  monsterMaxWait=1,
  monsterDelayToFire=4, # in the case of bonus level,
                        # it will be the time to disappear
  mudwidth=2, # not usefull here but have to be set to something
  throw='750A', # not usefull here but have to be set to something
  bgsound='bonuslevelbg',
  nbtokill=22,
  scoreMult=4,
  tempo=2400,
  monsters=['-bounce1','-bounce2','+bounce1','+bounce2','+bounce3','+bounce4','+bounce5','+bounce6'],
  bonus=[('ELH',1)],
  bonusLevel=1
  )

# there should be no 5th bonus level...

#-- ----------------------------------------------------


bossList['boss55']=MonsterBoss(
  name='boss03',
  width=1,
  score=150,
  speed=4,
  moveDist=1,
  probaToFire=20,
  probaToTurn=40,
  fireAgain=3,
  hitsToDie=3,
  rep='A',
  avoidPlayer=0,
  wavbase='boss3'
  )


levels['L55']=MonsterLevel(
  name='sewer5',
  world='sewer',
  levelnum='level5',
  width=15,
  waterContainerSize=5,
  nbMaxMonsters=4,
  probaMonsterAppears=50,
  probaMonster1Appears=90,
  probaMonster2Appears=70,
  probaBonus=50,
  monsterMaxWait=1,
  monsterDelayToFire=8,
  mudwidth=1,
  throw='750B',
  bgsound='sewer5',
  nbtokill=1,
  scoreMult=5,
  tempo=1000,
  monsters=['monster11','monster12','monster13','monster14','monster15'],
#  bossMonster='boss55',
  bossMonster=['boss05','boss06','boss07'],
  bgsoundBoss='sewerboss',
  bonus=[('EL',1),('B',12),('SM',1)]
  )
