#!/usr/bin/env python
#!!!! -*- coding: UTF-8 -*-

"""Test platform"""
from blindstation import *
import blindstation.game
from math import cos, sin, pi
import sys

class Intro(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'intro', 'init')
        self.label = Widget(self, 'label', 'init')
        self.label.focus_callback = self.label_focus_callback
        self.label.alt = "Test de phrase un peu longue pour\n voir se que cela va donner si la phrase est vraiment longue, bla, bla, bla"
        self.logo = Widget(self, 'logo', 'init')
        self.button = Widget(self, "button", 'init')
        self.button.text = "Press space or move here then press return for Menu"
	self.button.textpos = 'right'
        # self.button.color = [200, 200, 200, 255]
        self.button.rect = [50, 400, 500, 50]
        self.button.set_font("common/Vera.ttf", 20)
        self.button.validate_callback = self.button_callback
        self.listener = Listener()
        self.source = Source(self, "source")
        self.source.source_callback = self.source_callback
        self.source.queue("thunder")
        self.source.queue("bird")
        self.source.play()
        self.focus = self.button.__id__

    def label_focus_callback(self, name):
        print "label_focus callback of widget with name", name
    
    def button_callback(self, name, type, key):
        print "name: ", name
        print "focus owner: ", self.focus.name
        print "type:", type
        print "key:", key
        self.next = Menu
        self.nextargs = [1, 2]
        self.nextkeywords = {'foo': 3, 'toto': 4}

    def source_callback(self, name):
        self.source.source_callback = self.source_callback2
        self.source.play()

    def source_callback2(self, name):
        print "end of sound"
        
class Menu(Scene):
    def __init__(self, game, arg1 = 0, arg2 = 0, foo = 0, toto = 0):
        print "Initialising menu with arg1 =", arg1, " arg2 =", arg2, \
              " foo =", foo, " toto =", toto
        Scene.__init__(self, game, 'menu')
        self.color = [255, 255, 255, 255]
        self.forecolor = [0, 0, 0]
        self.backcolor = [255, 255, 255]
        self.background = 'data/background.png'
        self.label = Widget(self, "label")
        self.label.rect = [50, 50, 500, 45]
        self.label.text = "Choose your test scene"
        self.basic = Widget(self, "basic")
        self.basic.rect = [50, 110, 240, 45]
        self.basic.text = "Basic set of tests"
        self.basic.validate_callback = self.basic_callback
        self.basic.focus_callback = self.basic_focuscallback
        self.font = Widget(self, "font")
        self.font.rect = [50, 170, 240, 45]
        self.font.text = "Tests related to fonts"
        self.font.validate_callback = self.font_callback
        self.sound = Widget(self, "sound")
        self.sound.rect = [50, 230, 240, 45]
        self.sound.text = "Tests related to sounds"
        self.sound.validate_callback = self.sound_callback
        self.surround = Widget(self, "surround")
        self.surround.rect = [50, 290, 240, 45]
        self.surround.text = "Tests related to surround sound"
        self.surround.validate_callback = self.surround_callback
        self.timer = Widget(self, "timer")
        self.timer.rect = [310, 110, 240, 45]
        self.timer.text = "Tests related to timer"
        self.timer.validate_callback = self.timer_callback
        self.zoom = Widget(self, "zoom")
        self.zoom.rect = [310, 170, 240, 45]
        self.zoom.text = "Tests related to zoom"
        self.zoom.validate_callback = self.zoom_callback
        self.exit = Widget(self, "exit")
        self.exit.rect = [50, 400, 500, 50]
        self.exit.text = "Exit (q)"
        self.exit.shortcuts = [KeyCode.q]
        self.exit.validate_callback = self.exit_callback
        self.exit.flexikeys = [0, 3, 1, 2]

    def exit_callback(self, name, type, key):
        self.next = None

    def basic_callback(self, name, type, key):
        self.next = TestWidget

    def basic_focuscallback(self, name):
        print "basic a le focus"

    def sound_callback(self, name, type, key):
        self.next = TestSound

    def font_callback(self, name, type, key):
        self.next = TestColor

    def surround_callback(self, name, type, key):
        self.next = Surround

    def timer_callback(self, name, type, key):
        self.next = TestTimer

    def zoom_callback(self, name, type, key):
        self.next = TestZoom


class TestWidget(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'testwidget')
        self.color = [255, 255, 255, 255]
        self.label = Widget(self, "label")
        self.label.rect = [50, 50, 500, 340]
        self.label.text = """Now you can see a Widget which is used for basic textual output
If you have configured a Braille display, this text will also appear on it.
The component at the bottom of the screen is a Widget.\
 It is activated when pressing 'Return'.\
 It is also readable on a Braille display and\
 can be associated to some tactile board cells."""
        self.button = Widget(self,"button")
        self.button.rect = [50, 400, 500, 50]
        self.button.text = "Next feature"
        self.button.validate_callback = self.button_callback

    def button_callback(self, name, type, key):
        self.next = TestWidget2


class TestWidget2(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'testwidget2')
        self.color = [255, 255, 255, 255]
        self.label = Widget(self, "label")
        self.label.text = """You can also display a\
 simple picture with transparency effects."""
        self.label.rect = [50, 50, 500, 150]
        self.picture = Widget(self, "picture")
        self.picture.rect = [100, 220, 300, 161]
        self.picture.background = "data/image.png"
        self.picture.color = [0, 0, 0, 0]
        self.picture.focus_color = [255, 0, 0, 128]
        self.button = Widget(self, "button")
        self.button.text = "Back to Menu"
        self.button.rect = [50, 400, 500, 50]
        self.button.validate_callback = self.button_callback

    def button_callback(self, name, type, key):
        self.next = Menu

class TestTimer(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'testtimer')
        self.color = [255, 255, 255, 255]
        self.number = 0
        self.label = Widget(self, "label")
        self.label.rect = [50, 50, 500, 240]
        self.label.text = """This Scene shows that we can use\
 a Timer to send an event at a given time"""
        self.trace = Widget(self, "trace")
        self.trace.text = "called: " + `self.number`
        self.trace.rect = [50, 300, 500, 80]
        self.timer = Timer(self, "timer")
        self.timer.setTime(100)
        self.timer.timer_callback = self.timer_callback
        self.button = Widget(self, "button")
        self.button.rect = [50, 400, 500, 50]
        self.button.text = "Press return for next feature."
        self.button.validate_callback = self.button_callback

    def button_callback(self, name, type, key):
        self.next = Menu

    def timer_callback(self, name):
        self.number += 1
        self.trace.text = "called: " + `self.number`


class TestColor(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'testcolor')
        self.color = [255, 255, 255, 255]
        self.fontsize = 20
        self.forecolor = [0, 0, 0]
        self.backcolor = [255, 255, 255]
        self.backpicture_list = [None, 'data/back2.png', 'data/back3.png']
        self.backpicture_index = 0
        self.label = Widget(self, "label")
        self.label.rect = [50, 50, 500, 140]
        self.label.font = "common/Vera.ttf", self.fontsize
        self.label.text = "You can personalise colors and fonts like you want."
        self.label.color = [0, 0, 200, 128]
        self.label.focus_color = [200, 0, 0, 128]
        self.font = Widget(self, "font")
        self.font.rect = [50, 200, 240, 50]
        self.font.text = "Change font"
        self.font.validate_callback = self.font_callback
        self.backpicture = Widget(self, "backpicture")
        self.backpicture.rect = [300, 200, 250, 50]
        self.backpicture.text = "Change background picture"
        self.backpicture.validate_callback = self.backpicture_callback
        self.forecolorwidget = Widget(self, "forecolor")
        self.forecolorwidget.rect = [50, 300, 240, 50]
        self.forecolorwidget.text = "Change foreground color"
        self.forecolorwidget.validate_callback = self.forecolor_callback
        self.backcolorwidget = Widget(self, "backcolor")
        self.backcolorwidget.rect = [300, 300, 250, 50]
        self.backcolorwidget.text = "Change background color"
        self.backcolorwidget.validate_callback = self.backcolor_callback
        self.button = Widget(self, "button")
        self.button.rect = [50, 400, 500, 50]
        self.button.text = "Back to Menu"
        self.button.validate_callback = self.button_callback

    def button_callback(self, name, type, key):
        self.next = Menu

    def font_callback(self, name, type, key):
        self.fontsize += 1
        self.fontsize %= 30
        if(self.fontsize == 0):
            self.fontsize = 10
        self.label.set_font("common/Vera.ttf", self.fontsize)

    def forecolor_callback(self, name, type, key):
        self.forecolor[0] += 40
        self.forecolor[1] += 20
        self.forecolor[2] += 10
        self.forecolor[0] %= 255
        self.forecolor[1] %= 255
        self.forecolor[2] %= 255
        self.label.text_color = [self.forecolor[0], self.forecolor[1],
                                 self.forecolor[2]]
        self.label.focus_text_color = [255 - self.forecolor[0],
                                       255 - self.forecolor[1],
                                       255 - self.forecolor[2]]

    def backcolor_callback(self, name, type, key):
        self.backcolor[0] += 40
        self.backcolor[1] += 20
        self.backcolor[2] += 10
        self.backcolor[0] %= 255
        self.backcolor[1] %= 255
        self.backcolor[2] %= 255
        self.label.color = [self.backcolor[0], self.backcolor[1], self.backcolor[2], 128]
        self.label.focus_color = [255 - self.backcolor[0],
                                  255 - self.backcolor[1],
                                  255 - self.backcolor[2], 128]

    def backpicture_callback(self, name, type, key):
        self.backpicture_index = (self.backpicture_index + 1) % len(self.backpicture_list)
        self.label.background = self.backpicture_list[self.backpicture_index]


class TestSound(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'testsound')
        self.vol = 1.0
        self.color = [255, 255, 255, 255]
        self.looping = 0
        self.label = Widget(self, "label")
        self.label.text = "Sound demo"
        self.label.rect = [50, 50, 500, 50]
        self.basic = Widget(self, "basic")
        self.basic.text = "Hear a sound"
        self.basic.rect = [50, 110, 500, 50]
        self.basic.validate_callback = self.basic_callback
        self.loop = Widget(self, "loop")
        self.loop.text = "Looping sound on/off"
        self.loop.rect = [50, 170, 500, 50]
        self.loop.validate_callback = self.loop_callback
        self.volume = Widget(self, "volume")
        self.volume.text = "Change volume"
        self.volume.rect = [50, 230, 500, 50]
        self.volume.validate_callback = self.volume_callback
        self.button = Widget(self, "button")
        self.button.text = "Back to Menu"
        self.button.rect = [50, 400, 500, 50]
        self.button.validate_callback = self.button_callback
        self.listener = Listener()

    def button_callback(self, name, type, key):
        self.next = Menu

    def basic_callback(self, name, type, key):
        if(not hasattr(self, 'source')):
            self.source = Source(self, "source")
            self.source.queue("bird")
            self.source.queue("thunder")
        else:
            self.source.empty()
            self.source.queue("thunder")
            self.source.queue("bird")
        self.source.play()

    def loop_callback(self, name, type, key):
        if(not hasattr(self, 'loopsource')):
            self.loopsource = Source(self, "loopsource")
            self.loopsource.queue("bird")
            self.loopsource.queue("thunder")
            self.loopsource.setLooping(1)
        if self.looping == 1:
            self.looping = 0
            self.loopsource.stop()
        else:
            self.looping = 1
            self.loopsource.play()

    def volume_callback(self, name, type, key):
        self.vol = self.vol + 0.25
        if self.vol > 2.0:
            self.vol = 0.5
        self.listener.gain = self.vol

class Surround(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'surround')
        self.color = [255, 255, 255, 255]
        self.pos = [0, 0]
        self.angle = 0
        self.label = Widget(self, "label")
        self.label.text = """Demonstrating surround sound environment
In this screen you should hear two sounds initially on the left and right side.
If you have a surround sound card, it will be used.
You can also move using the arrow keys or the joystick."""
        self.label.rect = [50, 50, 500, 240]
        self.listener = Listener()
        self.listener.setPosition(0.0, 0.0, 0.0)
        self.listener.setOrientation(cos(self.angle), 0.0, sin(self.angle), 0.0, 1.0, 0.0)
        self.source1 = Source(self, "bird")
        self.source1.setLooping(1)
        self.source1.setSurround(1)
        self.source1.setPosition(-15.0, 0.0, 0.0)
        self.source1.queue("bird")
        self.source1.play()
        self.source2 = Source(self, "bong")
        self.source2.setLooping(1)
        self.source2.setSurround(1)
        self.source2.setPosition(15.0, 0.0, 0.0)
        self.source2.queue("bong")
        self.source2.play()
        self.coord = Widget(self, "coord")
        self.coord.rect = [50, 300, 500, 80]
        degree = (self.angle * (180 / pi)) % 360
        self.coord.text = 'position: %4.2f %4.2f\n' % (self.pos[0], self.pos[1]) + 'angle: %2.0f' % degree
        self.button = Widget(self, "button")
        self.button.text = "Back to Menu"
        self.button.rect = [50, 400, 500, 50]
        self.button.validate_callback = self.button_callback
        self.navig = Navigator(self)
        self.navig.navigator_callback = self.navigator_callback
        self.navig.repeat = 200

    def navigator_callback(self, dir):
        print "navigator callback, dir=", dir.x, dir.y
        if dir.x != 0:
            self.angle = self.angle + dir.x * pi / 16
            self.listener.setOrientation(cos(self.angle), 0.0, sin(self.angle), 0.0, 1.0, 0.0)
        if dir.y != 0:
            self.pos[0] = self.pos[0] + dir.y * .1 * cos(self.angle)
            self.pos[1] = self.pos[1] + dir.y * .1 * sin(self.angle)
            self.listener.setPosition(self.pos[0], 0.0, self.pos[1])
        if dir.x != 0 or dir.y != 0:
            degree = (self.angle * (180 / pi)) % 360
            self.coord.text = 'position: %4.2f %4.2f\n' % (self.pos[0], self.pos[1])\
                              + 'angle: %2.0f' % degree

    def button_callback(self, name, type, key):
        self.next = Menu

class TestZoom(Scene):
    def __init__(self, game):
        Scene.__init__(self, game, 'testzoom')
        self.color = [255, 255, 255, 255]
        self.background = 'data/background.png'
        self.label = Widget(self, "label")
        self.label.text = "Zoom demo (long text so that the scroll text function can be tested)"
        self.label.rect = [50, 50, 500, 50]
        self.hide = Widget(self, "hide")
        self.hide.text = "Hide a widget"
        self.hide.rect = [50, 110, 500, 50]
        self.hide.validate_callback = self.hide_callback
        self.unhide = Widget(self, "unhide")
        self.unhide.text = "Unhide a widget"
        self.unhide.rect = [50, 170, 500, 50]
        self.unhide.validate_callback = self.unhide_callback
        self.zoom = Widget(self, "zoom")
        self.zoom.text = "Zoom mode on/off (z)"
        self.zoom.rect = [50, 230, 500, 50]
        self.zoom.validate_callback = self.zoom_callback
        self.zoom.shortcuts = [KeyCode.z]
        self.logo = Widget(self, 'logo', 'init')
        self.button = Widget(self, "button")
        self.button.text = "Back to Menu"
        self.button.rect = [50, 400, 500, 50]
        self.button.validate_callback = self.button_callback

    def button_callback(self, name, type, key):
        self.next = Menu

    def hide_callback(self, name, type, key):
        self.label.hidden = True

    def unhide_callback(self, name, type, key):
        self.label.hidden = False

    def zoom_callback(self, name, type, key):
        self.zoom_mode = not self.zoom_mode

if __name__ == '__main__':
    test = Game(stylesheet = "test.xml", scene = Intro, lang = 'en')
    test.run()
    del test
    print "Test: The end"
