# -*- coding: UTF-8 -*-
"""Font related classe"""
import blindstation.cblind
import weakref
from blindstation.utils import BSCError, BSError

class FontServer(object):
    """Load fonts in cache for faster access"""
    def __init__(self):
        self.__fonts__ = {}

    def get_font(self, file, size):
        if self.__fonts__.has_key(file):
            if self.__fonts__[file].has_key(size):
                font = self.__fonts__[file][size]()
                if font is not None:
                    return font
            else:
                self.__fonts__[file][size] = None
        else:
            self.__fonts__[file] = {}
        font = Font(file, size)
        self.__fonts__[file][size] = weakref.ref(font)
        return font

class Font(object):
    """A font"""

    def __init__(self, filename, size):
        self.__filename__ = filename.encode('ascii')
        self.__size__ = size
        self.cfont = blindstation.cblind.CFont_init(self.__filename__, self.__size__)
        if self.cfont is None:
            raise BSCError, 'CFont_init failed'

    def __del__(self):
        if blindstation.cblind.CFont_del(self.cfont) == 0:
            raise BSCError, 'CFont_del failed'

    def size_text(self, text):
        size = blindstation.cblind.CFont_SizeText(self.cfont, text)
        if size == -1:
            raise BSCError, 'CFont_SizeText failed'
        else:
            return size

    def height(self):
        height = blindstation.cblind.CFont_Height(self.cfont)
        if height == -1:
            raise BSCError, 'CFont_Height failed'
        else:
            return height
        
