#! /usr/bin/python

from myBStools import PlayerBase
from blindstation.utils import BSError

import sys

#-- --------------------------------------------------------------------
class Player(PlayerBase):
  def __init__(self,position=0):
    PlayerBase.__init__(self)
    self.setPlace(position)
    self.canMove=0
    self.canShot=0
    self.isShooting=0

  def setPlace(self, pos):
    self.position=pos
    self.setPosition([pos*1.0+0.5,0,0])

  def moveTo(self,position):
    #self.canMove=0
    self.setPlace(position)

  def startLoop(self):
    self.canMove=1
    self.canShot=1
    
  def suspendLoop(self):
    self.canMove=0
    self.canShot=0

  def fires(self):
    self.canShot=0
    self.isShooting=1

  def fireCompleted(self):
    self.isShooting=0
    self.canShot=1

# -- ----------------------------------------------------------------
class baseMudsplatObject:
  """
  Base Object from which are derivated Monster and BonusObject.
  BossMonster is itself derivated from Monster
  """
  def __init__(self, name, width, score, rep):
    # Fixed parameters (description of the object, should not be modified)
    self.name=name
    self.score=score
    self.width=width
    self.repr=rep
    self.appearingPosition=-1

  def eInit(self):
    # Work parameters, that need to be init at each start of level
    # and to be saved
    self.cpos=-1

  # -- --------------------------------------------------------------
  def setPlace(self,p): self.cpos=p
  def setAppearingPlace(self,p): self.appearingPosition=p
  
  def isPresent(self): return self.cpos>=0
  def isReadyToAppear(self): return self.appearingPosition>=0

  def preparesToAppear(self,p):
    self.setAppearingPlace(p)

  def cancelIt(self):
    self.appearingPosition=-1
    self.cpos=-1
    
  def appears(self):
    if self.appearingPosition==-1:
      emergencyExit("Impossible, no appearing position available !!")
    self.setPlace(self.appearingPosition)
    self.appearingPosition=-1
    
  def disappears(self): self.cpos=-1

  # -- --------------------------------------------------------------

  #Probablement inutile
  #def isScared(self,playerPos):
  #  return self.cpos<=playerPos and playerPos<self.cpos+self.width

  def sndPosition(self,playerPos):
    # The position 'modified' so that it seems to be in front of the
    # player as soon as a part of the monster is.
    # Next is the original version, where the monster sound always
    # come from the middle of the monster
    if playerPos<=self.cpos: r=self.cpos
    elif playerPos>=self.cpos+self.width-1: r=self.cpos+self.width-1
    else: r=playerPos
    return [(r*1.0+0.5),1.0,0.0]

  #def sndPosition(self,playerPos):
  #  return [(self.cpos+(self.width-1)*0.5)*self.step,0.0,0.0]


# -- ----------------------------------------------------------------
class BonusObject(baseMudsplatObject):
  def __init__(self, name, kind, score, rep, bounce, hitwav):
    baseMudsplatObject.__init__(self,name,1,score,rep)
    self.kind=kind
    # kind='EL': extra lives
    # kind='EP': extra points
    # kind='B':  bomb
    # kind='UW': unlimited water
    # kind='SM': score multiplier
    # kind='BL': bonus level object
    self.bounce=bounce
    self.hitwav=hitwav

  def eInit(self):
    # Work parameters, that need to be init at each start of level
    # and to be saved
    baseMudsplatObject.eInit(self)
    self.direction=0

  def preparesToAppear(self,place): 
    # direction: -1: to left, 1: to right
    if place==0:
      self.setAppearingPlace(0)
      self.direction=1
    else:
      self.setAppearingPlace(place-self.width)
      self.direction=-1

# -- ----------------------------------------------------------------
class Monster(baseMudsplatObject):
  def __init__(self, name, cat, rep, wavbase=''):
    self.rep=rep
    self.cat=cat
    self.canShoot=1
    
    if cat==3: # big ones
      width=3
      score=5
    elif cat==2: # medium ones
      width=2
      score=10
    elif cat==1: # nasty ones
      width=1
      score=20
      
    elif cat==11: # bonus level monsters (good ones)
      width=1
      score=10
      self.canShoot=0
    elif cat==12: # bonus level monsters (bad ones)
      width=1
      score=-20
      self.canShoot=0
      
    else:
      raise BSError, 'Unknown monster category'
    baseMudsplatObject.__init__(self,name,width,score,rep)

    if wavbase=='': self.wavname=self.name
    else:           self.wavname=wavbase

  def eInit(self,delay):
    # Work parameters, that need to be init at each start of level
    # and to be saved
    baseMudsplatObject.eInit(self)
    self.canFire=0
    self.delayToFire=0
    self.delayToFireSrc=delay
    self.canAppear=1
    self.delayToAppear=0
    
  def preparesToAppear(self,pos):
    self.setAppearingPlace(pos)
    self.canAppear=0
    self.canFire=0
    self.delayToFire=self.delayToFireSrc

  def killed(self,delayToAppear):
    self.disappears()
    self.delayToAppear=delayToAppear
    # delayToAppear is the delay during which a monster cannot appear
    # after being shot
    self.delayToFire=0

  def fires(self):
    self.canFire=0

  def hitSound(self,last=0):
    ret='hit'+`self.cat`
    if last==1: ret=ret+'l'
    return ret
    
  def tempoUpdate(self):
    if self.delayToAppear!=0:
      self.delayToAppear-=1
      if self.delayToAppear==0: self.canAppear=1
    if self.delayToFire!=0:
      self.delayToFire-=1
      if self.delayToFire==0: self.canFire=1

# -- ----------------------------------------------------------------
class MonsterBoss(Monster):
  def __init__(self, name, width, score, speed, moveDist, 
               probaToFire, probaToTurn, fireAgain, hitsToDie, rep, 
               wavbase='', hitwav='', killedwav='',
               avoidPlayer=0, shrinkable=0,
               ):
    baseMudsplatObject.__init__(self,name,width,score,rep)

    self.speed=speed       # movement speed: e.g 1 or 2 times per time unit 
    self.moveDist=moveDist # movement distance: between 1 to "size" (in cells)
    self.probaToFire=probaToFire # probability to fire every time unit: in %
    self.probaToTurn=probaToTurn # probability that the monster changes direction
    self.fireAgain=fireAgain # fire again delay: 1-5 time units
    self.hitsToDie=hitsToDie # number of hits to be killed: e.g 2-7
    self.avoidPlayer=avoidPlayer
    self.shrinkable=shrinkable

    if wavbase=='': self.wavname=self.name
    else:           self.wavname=wavbase
    
    if hitwav=='':    self.hitwavname=self.wavname+'hit'
    else:             self.hitwavname=hitwav

    if killedwav=='': self.killedwavname=self.wavname+'killed'
    else:             self.killedwavname=killedwav

  def eInit(self,delay):
    Monster.eInit(self, delay)
    self.hits=0

  def preparesToAppear(self,place): 
    # direction: -1: to left, 1: to right
    self.setAppearingPlace(place)
    if place==0:
      self.direction=1
    else:
      self.direction=-1
    self.canFire=0
    self.delayToFire=self.delayToFireSrc

  def missed(self):
    self.delayToFire=self.fireAgain
    self.canFire=0

  def hitted(self):
    # Return 1 if monster is dead, 0 elswise
    self.delayToFire=self.fireAgain
    self.canFire=0
    self.hits+=1
    if self.hits>=self.hitsToDie: return 1
    return 0

  def dieNext(self):
    return self.hits+1>=self.hitsToDie
  
# -- ----------------------------------------------------------------
class MonsterLevel:
  def __init__(self,
               name,
               world,               # world
               levelnum,            # levelnum sound
               width,               # width of the play ground
               nbMaxMonsters,       # max number of monsters at the same time
               probaMonsterAppears, # probability that a monster appears
               probaBonus,          # probability that a bonus appears
               monsterMaxWait,      # max waiting time with no monster at all
               monsterDelayToFire,  # time a monster waits before he fires

               mudwidth,            # distance the player has to run to avaid the mud throw by monster
               throw,               # what 'throw' wav file
               nbtokill,            # nb to kill for next level
               scoreMult,           # score mutliplicator (should be 1 in the 1st world,...)
               tempo,
               monsters,            # list of monsters that may appear in this level
               waterContainerSize=5, # Maximum number of units in the water container
               waterRefillUnits=1,   # Number of units to refill each time unit
               waterRefillDelay=2,   # Number of time units between water refills

               bgsound=None,        # bg sound, read in data/bgsounds
               bossMonster=None,    # none if no bosses to appear, else it is a list
               sonix=None,          # empty if no sonix
               bgsoundBoss=None,    # bgsound when boss appears, if '' it will not change
               bonus=[],            # empty if no bonus to appear
               probaMonster1Appears=0,
               probaMonster2Appears=0,

               bonusLevel=0
               ):

    self.name=name
    self.world=world
    self.levelnum=levelnum
    self.width=width
    self.tempo=tempo

    self.monsters=monsters
    
    self.nbMaxMonsters=nbMaxMonsters
    self.probaMonster=probaMonsterAppears
    self.probaBonus=probaBonus
    if probaMonster1Appears==0:
      self.probaMonster1=self.probaMonster
      self.probaMonster2=self.probaMonster
    else:
      self.probaMonster1=probaMonster1Appears
      if probaMonster2Appears==0:
        self.probaMonster2=self.probaMonster
      else:
        self.probaMonster2=probaMonster2Appears

    self.monsterMaxWait=monsterMaxWait
    self.monsterDelay=monsterDelayToFire

    self.waterContainerSize=waterContainerSize
    self.waterRefillUnits=waterRefillUnits
    self.waterRefillDelay=waterRefillDelay

    self.mudwidth=mudwidth
    self.scoreMult=scoreMult

    self.throw=throw
    self.bgsound=bgsound

    self.nbtokill=nbtokill
    self.bonus=bonus
    self.sonix=sonix
    self.bossMonster=bossMonster
    self.bgsoundBoss=bgsoundBoss

    self.bonusLevel=bonusLevel
