# -*- coding: UTF-8 -*-
"""Event related classes"""
import blindstation.cblind
from blindstation.utils import BSCError, BSError

class Event(object):
    def __init__(self, cevent):
        """Initialise the event form a cevent list"""
        self.type = cevent[0]
        if self.type == EventCode.USEREVENT:
            self.code = cevent[1]
            if self.code == UserCode.CTIMER:
                self.id = cevent[2]
            elif self.code == UserCode.BOARD:
                self.key = cevent[2]
            elif self.code == UserCode.BRAILLE:
                self.key = cevent[2]
        elif self.type == EventCode.KEYDOWN:
            self.sym = cevent[1]
            self.unicode = cevent[2]
            self.mod = cevent[3]
        elif self.type == EventCode.KEYUP:
            self.sym = cevent[1]
        elif self.type == EventCode.JOYAXISMOTION:
            self.which = cevent[1]
            self.axis = cevent[2]
            self.value = cevent[3]
        elif self.type == EventCode.JOYBUTTONDOWN:
            self.which = cevent[1]
            self.button = cevent[2]
            self.state = cevent[3]

class EventCode(object):
    NOEVENT = blindstation.cblind.SDL_NOEVENT
    QUIT = blindstation.cblind.SDL_QUIT
    KEYDOWN = blindstation.cblind.SDL_KEYDOWN
    KEYUP = blindstation.cblind.SDL_KEYUP
    USEREVENT = blindstation.cblind.SDL_USEREVENT
    JOYAXISMOTION = blindstation.cblind.SDL_JOYAXISMOTION
    JOYBUTTONDOWN = blindstation.cblind.SDL_JOYBUTTONDOWN

class UserCode(object):
    CTIMER = blindstation.cblind.EVENT_CTIMER
    BOARD = blindstation.cblind.EVENT_BOARD
    BRAILLE = blindstation.cblind.EVENT_BRAILLE

class KeyMod(object):
    NONE = blindstation.cblind.KMOD_NONE
    LSHIFT = blindstation.cblind.KMOD_LSHIFT
    RSHIFT = blindstation.cblind.KMOD_RSHIFT
    LCTRL = blindstation.cblind.KMOD_LCTRL
    RCTRL = blindstation.cblind.KMOD_RCTRL
    LALT = blindstation.cblind.KMOD_LALT
    RALT = blindstation.cblind.KMOD_RALT
    LMETA = blindstation.cblind.KMOD_LMETA
    RMETA = blindstation.cblind.KMOD_RMETA
    NUM = blindstation.cblind.KMOD_NUM
    CAPS = blindstation.cblind.KMOD_CAPS
    MODE = blindstation.cblind.KMOD_MODE
    CTRL = LCTRL | RCTRL
    SHIFT = LSHIFT | RSHIFT
    ALT = LALT | RALT
    META = LMETA | RMETA

class KeyCode(object):
    UNKNOWN = blindstation.cblind.SDLK_UNKNOWN
    FIRST = blindstation.cblind.SDLK_FIRST
    BACKSPACE = blindstation.cblind.SDLK_BACKSPACE
    TAB = blindstation.cblind.SDLK_TAB
    CLEAR = blindstation.cblind.SDLK_CLEAR
    RETURN = blindstation.cblind.SDLK_RETURN
    PAUSE = blindstation.cblind.SDLK_PAUSE
    ESCAPE = blindstation.cblind.SDLK_ESCAPE
    SPACE = blindstation.cblind.SDLK_SPACE
    EXCLAIM = blindstation.cblind.SDLK_EXCLAIM
    QUOTEDBL = blindstation.cblind.SDLK_QUOTEDBL
    HASH = blindstation.cblind.SDLK_HASH
    DOLLAR = blindstation.cblind.SDLK_DOLLAR
    AMPERSAND = blindstation.cblind.SDLK_AMPERSAND
    QUOTE = blindstation.cblind.SDLK_QUOTE
    LEFTPAREN = blindstation.cblind.SDLK_LEFTPAREN
    RIGHTPAREN = blindstation.cblind.SDLK_RIGHTPAREN
    ASTERISK = blindstation.cblind.SDLK_ASTERISK
    PLUS = blindstation.cblind.SDLK_PLUS
    COMMA = blindstation.cblind.SDLK_COMMA
    MINUS = blindstation.cblind.SDLK_MINUS
    PERIOD = blindstation.cblind.SDLK_PERIOD
    SLASH = blindstation.cblind.SDLK_SLASH
    K_0 = blindstation.cblind.SDLK_0
    K_1 = blindstation.cblind.SDLK_1
    K_2 = blindstation.cblind.SDLK_2
    K_3 = blindstation.cblind.SDLK_3
    K_4 = blindstation.cblind.SDLK_4
    K_5 = blindstation.cblind.SDLK_5
    K_6 = blindstation.cblind.SDLK_6
    K_7 = blindstation.cblind.SDLK_7
    K_8 = blindstation.cblind.SDLK_8
    K_9 = blindstation.cblind.SDLK_9
    COLON = blindstation.cblind.SDLK_COLON
    SEMICOLON = blindstation.cblind.SDLK_SEMICOLON
    LESS = blindstation.cblind.SDLK_LESS
    EQUALS = blindstation.cblind.SDLK_EQUALS
    GREATER = blindstation.cblind.SDLK_GREATER
    QUESTION = blindstation.cblind.SDLK_QUESTION
    AT = blindstation.cblind.SDLK_AT
    LEFTBRACKET = blindstation.cblind.SDLK_LEFTBRACKET
    BACKSLASH = blindstation.cblind.SDLK_BACKSLASH
    RIGHTBRACKET = blindstation.cblind.SDLK_RIGHTBRACKET
    CARET = blindstation.cblind.SDLK_CARET
    UNDERSCORE = blindstation.cblind.SDLK_UNDERSCORE
    BACKQUOTE = blindstation.cblind.SDLK_BACKQUOTE
    a = blindstation.cblind.SDLK_a
    b = blindstation.cblind.SDLK_b
    c = blindstation.cblind.SDLK_c
    d = blindstation.cblind.SDLK_d
    e = blindstation.cblind.SDLK_e
    f = blindstation.cblind.SDLK_f
    g = blindstation.cblind.SDLK_g
    h = blindstation.cblind.SDLK_h
    i = blindstation.cblind.SDLK_i
    j = blindstation.cblind.SDLK_j
    k = blindstation.cblind.SDLK_k
    l = blindstation.cblind.SDLK_l
    m = blindstation.cblind.SDLK_m
    n = blindstation.cblind.SDLK_n
    o = blindstation.cblind.SDLK_o
    p = blindstation.cblind.SDLK_p
    q = blindstation.cblind.SDLK_q
    r = blindstation.cblind.SDLK_r
    s = blindstation.cblind.SDLK_s
    t = blindstation.cblind.SDLK_t
    u = blindstation.cblind.SDLK_u
    v = blindstation.cblind.SDLK_v
    w = blindstation.cblind.SDLK_w
    x = blindstation.cblind.SDLK_x
    y = blindstation.cblind.SDLK_y
    z = blindstation.cblind.SDLK_z
    DELETE = blindstation.cblind.SDLK_DELETE
    WORLD_0 = blindstation.cblind.SDLK_WORLD_0
    WORLD_1 = blindstation.cblind.SDLK_WORLD_1
    WORLD_2 = blindstation.cblind.SDLK_WORLD_2
    WORLD_3 = blindstation.cblind.SDLK_WORLD_3
    WORLD_4 = blindstation.cblind.SDLK_WORLD_4
    WORLD_5 = blindstation.cblind.SDLK_WORLD_5
    WORLD_6 = blindstation.cblind.SDLK_WORLD_6
    WORLD_7 = blindstation.cblind.SDLK_WORLD_7
    WORLD_8 = blindstation.cblind.SDLK_WORLD_8
    WORLD_9 = blindstation.cblind.SDLK_WORLD_9
    WORLD_10 = blindstation.cblind.SDLK_WORLD_10
    WORLD_11 = blindstation.cblind.SDLK_WORLD_11
    WORLD_12 = blindstation.cblind.SDLK_WORLD_12
    WORLD_13 = blindstation.cblind.SDLK_WORLD_13
    WORLD_14 = blindstation.cblind.SDLK_WORLD_14
    WORLD_15 = blindstation.cblind.SDLK_WORLD_15
    WORLD_16 = blindstation.cblind.SDLK_WORLD_16
    WORLD_17 = blindstation.cblind.SDLK_WORLD_17
    WORLD_18 = blindstation.cblind.SDLK_WORLD_18
    WORLD_19 = blindstation.cblind.SDLK_WORLD_19
    WORLD_20 = blindstation.cblind.SDLK_WORLD_20
    WORLD_21 = blindstation.cblind.SDLK_WORLD_21
    WORLD_22 = blindstation.cblind.SDLK_WORLD_22
    WORLD_23 = blindstation.cblind.SDLK_WORLD_23
    WORLD_24 = blindstation.cblind.SDLK_WORLD_24
    WORLD_25 = blindstation.cblind.SDLK_WORLD_25
    WORLD_26 = blindstation.cblind.SDLK_WORLD_26
    WORLD_27 = blindstation.cblind.SDLK_WORLD_27
    WORLD_28 = blindstation.cblind.SDLK_WORLD_28
    WORLD_29 = blindstation.cblind.SDLK_WORLD_29
    WORLD_30 = blindstation.cblind.SDLK_WORLD_30
    WORLD_31 = blindstation.cblind.SDLK_WORLD_31
    WORLD_32 = blindstation.cblind.SDLK_WORLD_32
    WORLD_33 = blindstation.cblind.SDLK_WORLD_33
    WORLD_34 = blindstation.cblind.SDLK_WORLD_34
    WORLD_35 = blindstation.cblind.SDLK_WORLD_35
    WORLD_36 = blindstation.cblind.SDLK_WORLD_36
    WORLD_37 = blindstation.cblind.SDLK_WORLD_37
    WORLD_38 = blindstation.cblind.SDLK_WORLD_38
    WORLD_39 = blindstation.cblind.SDLK_WORLD_39
    WORLD_40 = blindstation.cblind.SDLK_WORLD_40
    WORLD_41 = blindstation.cblind.SDLK_WORLD_41
    WORLD_42 = blindstation.cblind.SDLK_WORLD_42
    WORLD_43 = blindstation.cblind.SDLK_WORLD_43
    WORLD_44 = blindstation.cblind.SDLK_WORLD_44
    WORLD_45 = blindstation.cblind.SDLK_WORLD_45
    WORLD_46 = blindstation.cblind.SDLK_WORLD_46
    WORLD_47 = blindstation.cblind.SDLK_WORLD_47
    WORLD_48 = blindstation.cblind.SDLK_WORLD_48
    WORLD_49 = blindstation.cblind.SDLK_WORLD_49
    WORLD_50 = blindstation.cblind.SDLK_WORLD_50
    WORLD_51 = blindstation.cblind.SDLK_WORLD_51
    WORLD_52 = blindstation.cblind.SDLK_WORLD_52
    WORLD_53 = blindstation.cblind.SDLK_WORLD_53
    WORLD_54 = blindstation.cblind.SDLK_WORLD_54
    WORLD_55 = blindstation.cblind.SDLK_WORLD_55
    WORLD_56 = blindstation.cblind.SDLK_WORLD_56
    WORLD_57 = blindstation.cblind.SDLK_WORLD_57
    WORLD_58 = blindstation.cblind.SDLK_WORLD_58
    WORLD_59 = blindstation.cblind.SDLK_WORLD_59
    WORLD_60 = blindstation.cblind.SDLK_WORLD_60
    WORLD_61 = blindstation.cblind.SDLK_WORLD_61
    WORLD_62 = blindstation.cblind.SDLK_WORLD_62
    WORLD_63 = blindstation.cblind.SDLK_WORLD_63
    WORLD_64 = blindstation.cblind.SDLK_WORLD_64
    WORLD_65 = blindstation.cblind.SDLK_WORLD_65
    WORLD_66 = blindstation.cblind.SDLK_WORLD_66
    WORLD_67 = blindstation.cblind.SDLK_WORLD_67
    WORLD_68 = blindstation.cblind.SDLK_WORLD_68
    WORLD_69 = blindstation.cblind.SDLK_WORLD_69
    WORLD_70 = blindstation.cblind.SDLK_WORLD_70
    WORLD_71 = blindstation.cblind.SDLK_WORLD_71
    WORLD_72 = blindstation.cblind.SDLK_WORLD_72
    WORLD_73 = blindstation.cblind.SDLK_WORLD_73
    WORLD_74 = blindstation.cblind.SDLK_WORLD_74
    WORLD_75 = blindstation.cblind.SDLK_WORLD_75
    WORLD_76 = blindstation.cblind.SDLK_WORLD_76
    WORLD_77 = blindstation.cblind.SDLK_WORLD_77
    WORLD_78 = blindstation.cblind.SDLK_WORLD_78
    WORLD_79 = blindstation.cblind.SDLK_WORLD_79
    WORLD_80 = blindstation.cblind.SDLK_WORLD_80
    WORLD_81 = blindstation.cblind.SDLK_WORLD_81
    WORLD_82 = blindstation.cblind.SDLK_WORLD_82
    WORLD_83 = blindstation.cblind.SDLK_WORLD_83
    WORLD_84 = blindstation.cblind.SDLK_WORLD_84
    WORLD_85 = blindstation.cblind.SDLK_WORLD_85
    WORLD_86 = blindstation.cblind.SDLK_WORLD_86
    WORLD_87 = blindstation.cblind.SDLK_WORLD_87
    WORLD_88 = blindstation.cblind.SDLK_WORLD_88
    WORLD_89 = blindstation.cblind.SDLK_WORLD_89
    WORLD_90 = blindstation.cblind.SDLK_WORLD_90
    WORLD_91 = blindstation.cblind.SDLK_WORLD_91
    WORLD_92 = blindstation.cblind.SDLK_WORLD_92
    WORLD_93 = blindstation.cblind.SDLK_WORLD_93
    WORLD_94 = blindstation.cblind.SDLK_WORLD_94
    WORLD_95 = blindstation.cblind.SDLK_WORLD_95
    KP0 = blindstation.cblind.SDLK_KP0
    KP1 = blindstation.cblind.SDLK_KP1
    KP2 = blindstation.cblind.SDLK_KP2
    KP3 = blindstation.cblind.SDLK_KP3
    KP4 = blindstation.cblind.SDLK_KP4
    KP5 = blindstation.cblind.SDLK_KP5
    KP6 = blindstation.cblind.SDLK_KP6
    KP7 = blindstation.cblind.SDLK_KP7
    KP8 = blindstation.cblind.SDLK_KP8
    KP9 = blindstation.cblind.SDLK_KP9
    KP_PERIOD = blindstation.cblind.SDLK_KP_PERIOD
    KP_DIVIDE = blindstation.cblind.SDLK_KP_DIVIDE
    KP_MULTIPLY = blindstation.cblind.SDLK_KP_MULTIPLY
    KP_MINUS = blindstation.cblind.SDLK_KP_MINUS
    KP_PLUS = blindstation.cblind.SDLK_KP_PLUS
    KP_ENTER = blindstation.cblind.SDLK_KP_ENTER
    KP_EQUALS = blindstation.cblind.SDLK_KP_EQUALS
    UP = blindstation.cblind.SDLK_UP
    DOWN = blindstation.cblind.SDLK_DOWN
    RIGHT = blindstation.cblind.SDLK_RIGHT
    LEFT = blindstation.cblind.SDLK_LEFT
    INSERT = blindstation.cblind.SDLK_INSERT
    HOME = blindstation.cblind.SDLK_HOME
    END = blindstation.cblind.SDLK_END
    PAGEUP = blindstation.cblind.SDLK_PAGEUP
    PAGEDOWN = blindstation.cblind.SDLK_PAGEDOWN
    F1 = blindstation.cblind.SDLK_F1
    F2 = blindstation.cblind.SDLK_F2
    F3 = blindstation.cblind.SDLK_F3
    F4 = blindstation.cblind.SDLK_F4
    F5 = blindstation.cblind.SDLK_F5
    F6 = blindstation.cblind.SDLK_F6
    F7 = blindstation.cblind.SDLK_F7
    F8 = blindstation.cblind.SDLK_F8
    F9 = blindstation.cblind.SDLK_F9
    F10 = blindstation.cblind.SDLK_F10
    F11 = blindstation.cblind.SDLK_F11
    F12 = blindstation.cblind.SDLK_F12
    F13 = blindstation.cblind.SDLK_F13
    F14 = blindstation.cblind.SDLK_F14
    F15 = blindstation.cblind.SDLK_F15
    NUMLOCK = blindstation.cblind.SDLK_NUMLOCK
    CAPSLOCK = blindstation.cblind.SDLK_CAPSLOCK
    SCROLLOCK = blindstation.cblind.SDLK_SCROLLOCK
    RSHIFT = blindstation.cblind.SDLK_RSHIFT
    LSHIFT = blindstation.cblind.SDLK_LSHIFT
    RCTRL = blindstation.cblind.SDLK_RCTRL
    LCTRL = blindstation.cblind.SDLK_LCTRL
    RALT = blindstation.cblind.SDLK_RALT
    LALT = blindstation.cblind.SDLK_LALT
    RMETA = blindstation.cblind.SDLK_RMETA
    LMETA = blindstation.cblind.SDLK_LMETA
    LSUPER = blindstation.cblind.SDLK_LSUPER
    RSUPER = blindstation.cblind.SDLK_RSUPER
    MODE = blindstation.cblind.SDLK_MODE
    COMPOSE = blindstation.cblind.SDLK_COMPOSE
    HELP = blindstation.cblind.SDLK_HELP
    PRINT = blindstation.cblind.SDLK_PRINT
    SYSREQ = blindstation.cblind.SDLK_SYSREQ
    BREAK = blindstation.cblind.SDLK_BREAK
    MENU = blindstation.cblind.SDLK_MENU
    POWER = blindstation.cblind.SDLK_POWER
    EURO = blindstation.cblind.SDLK_EURO
    UNDO = blindstation.cblind.SDLK_UNDO
    
class BrlKeyCode(object):
    UNKNOWN = blindstation.cblind.BRLK_UNKNOWN
    NONE = blindstation.cblind.BRLK_NONE
    BACKSPACE = blindstation.cblind.BRLK_BACKSPACE
    TAB = blindstation.cblind.BRLK_TAB
    CLEAR = blindstation.cblind.BRLK_CLEAR
    RETURN = blindstation.cblind.BRLK_RETURN
    PAUSE = blindstation.cblind.BRLK_PAUSE
    ESCAPE = blindstation.cblind.BRLK_ESCAPE
    SPACE = blindstation.cblind.BRLK_SPACE
    EXCLAIM = blindstation.cblind.BRLK_EXCLAIM
    QUOTEDBL = blindstation.cblind.BRLK_QUOTEDBL
    HASH = blindstation.cblind.BRLK_HASH
    DOLLAR = blindstation.cblind.BRLK_DOLLAR
    AMPERSAND = blindstation.cblind.BRLK_AMPERSAND
    QUOTE = blindstation.cblind.BRLK_QUOTE
    LEFTPAREN = blindstation.cblind.BRLK_LEFTPAREN
    RIGHTPAREN = blindstation.cblind.BRLK_RIGHTPAREN
    ASTERISK = blindstation.cblind.BRLK_ASTERISK
    PLUS = blindstation.cblind.BRLK_PLUS
    COMMA = blindstation.cblind.BRLK_COMMA
    MINUS = blindstation.cblind.BRLK_MINUS
    PERIOD = blindstation.cblind.BRLK_PERIOD
    SLASH = blindstation.cblind.BRLK_SLASH
    K_0 = blindstation.cblind.BRLK_0
    K_1 = blindstation.cblind.BRLK_1
    K_2 = blindstation.cblind.BRLK_2
    K_3 = blindstation.cblind.BRLK_3
    K_4 = blindstation.cblind.BRLK_4
    K_5 = blindstation.cblind.BRLK_5
    K_6 = blindstation.cblind.BRLK_6
    K_7 = blindstation.cblind.BRLK_7
    K_8 = blindstation.cblind.BRLK_8
    K_9 = blindstation.cblind.BRLK_9
    COLON = blindstation.cblind.BRLK_COLON
    SEMICOLON = blindstation.cblind.BRLK_SEMICOLON
    LESS = blindstation.cblind.BRLK_LESS
    EQUALS = blindstation.cblind.BRLK_EQUALS
    GREATER = blindstation.cblind.BRLK_GREATER
    QUESTION = blindstation.cblind.BRLK_QUESTION
    AT = blindstation.cblind.BRLK_AT
    LEFTBRACKET = blindstation.cblind.BRLK_LEFTBRACKET
    BACKSLASH = blindstation.cblind.BRLK_BACKSLASH
    RIGHTBRACKET = blindstation.cblind.BRLK_RIGHTBRACKET
    CARET = blindstation.cblind.BRLK_CARET
    UNDERSCORE = blindstation.cblind.BRLK_UNDERSCORE
    BACKQUOTE = blindstation.cblind.BRLK_BACKQUOTE
    a = blindstation.cblind.BRLK_a
    b = blindstation.cblind.BRLK_b
    c = blindstation.cblind.BRLK_c
    d = blindstation.cblind.BRLK_d
    e = blindstation.cblind.BRLK_e
    f = blindstation.cblind.BRLK_f
    g = blindstation.cblind.BRLK_g
    h = blindstation.cblind.BRLK_h
    i = blindstation.cblind.BRLK_i
    j = blindstation.cblind.BRLK_j
    k = blindstation.cblind.BRLK_k
    l = blindstation.cblind.BRLK_l
    m = blindstation.cblind.BRLK_m
    n = blindstation.cblind.BRLK_n
    o = blindstation.cblind.BRLK_o
    p = blindstation.cblind.BRLK_p
    q = blindstation.cblind.BRLK_q
    r = blindstation.cblind.BRLK_r
    s = blindstation.cblind.BRLK_s
    t = blindstation.cblind.BRLK_t
    u = blindstation.cblind.BRLK_u
    v = blindstation.cblind.BRLK_v
    w = blindstation.cblind.BRLK_w
    x = blindstation.cblind.BRLK_x
    y = blindstation.cblind.BRLK_y
    z = blindstation.cblind.BRLK_z
    DELETE = blindstation.cblind.BRLK_DELETE
    WORLD_0 = blindstation.cblind.BRLK_WORLD_0
    WORLD_1 = blindstation.cblind.BRLK_WORLD_1
    WORLD_2 = blindstation.cblind.BRLK_WORLD_2
    WORLD_3 = blindstation.cblind.BRLK_WORLD_3
    WORLD_4 = blindstation.cblind.BRLK_WORLD_4
    WORLD_5 = blindstation.cblind.BRLK_WORLD_5
    WORLD_6 = blindstation.cblind.BRLK_WORLD_6
    WORLD_7 = blindstation.cblind.BRLK_WORLD_7
    WORLD_8 = blindstation.cblind.BRLK_WORLD_8
    WORLD_9 = blindstation.cblind.BRLK_WORLD_9
    WORLD_10 = blindstation.cblind.BRLK_WORLD_10
    WORLD_11 = blindstation.cblind.BRLK_WORLD_11
    WORLD_12 = blindstation.cblind.BRLK_WORLD_12
    WORLD_13 = blindstation.cblind.BRLK_WORLD_13
    WORLD_14 = blindstation.cblind.BRLK_WORLD_14
    WORLD_15 = blindstation.cblind.BRLK_WORLD_15
    WORLD_16 = blindstation.cblind.BRLK_WORLD_16
    WORLD_17 = blindstation.cblind.BRLK_WORLD_17
    WORLD_18 = blindstation.cblind.BRLK_WORLD_18
    WORLD_19 = blindstation.cblind.BRLK_WORLD_19
    WORLD_20 = blindstation.cblind.BRLK_WORLD_20
    WORLD_21 = blindstation.cblind.BRLK_WORLD_21
    WORLD_22 = blindstation.cblind.BRLK_WORLD_22
    WORLD_23 = blindstation.cblind.BRLK_WORLD_23
    WORLD_24 = blindstation.cblind.BRLK_WORLD_24
    WORLD_25 = blindstation.cblind.BRLK_WORLD_25
    WORLD_26 = blindstation.cblind.BRLK_WORLD_26
    WORLD_27 = blindstation.cblind.BRLK_WORLD_27
    WORLD_28 = blindstation.cblind.BRLK_WORLD_28
    WORLD_29 = blindstation.cblind.BRLK_WORLD_29
    WORLD_30 = blindstation.cblind.BRLK_WORLD_30
    WORLD_31 = blindstation.cblind.BRLK_WORLD_31
    WORLD_32 = blindstation.cblind.BRLK_WORLD_32
    WORLD_33 = blindstation.cblind.BRLK_WORLD_33
    WORLD_34 = blindstation.cblind.BRLK_WORLD_34
    WORLD_35 = blindstation.cblind.BRLK_WORLD_35
    WORLD_36 = blindstation.cblind.BRLK_WORLD_36
    WORLD_37 = blindstation.cblind.BRLK_WORLD_37
    WORLD_38 = blindstation.cblind.BRLK_WORLD_38
    WORLD_39 = blindstation.cblind.BRLK_WORLD_39
    WORLD_40 = blindstation.cblind.BRLK_WORLD_40
    WORLD_41 = blindstation.cblind.BRLK_WORLD_41
    WORLD_42 = blindstation.cblind.BRLK_WORLD_42
    WORLD_43 = blindstation.cblind.BRLK_WORLD_43
    WORLD_44 = blindstation.cblind.BRLK_WORLD_44
    WORLD_45 = blindstation.cblind.BRLK_WORLD_45
    WORLD_46 = blindstation.cblind.BRLK_WORLD_46
    WORLD_47 = blindstation.cblind.BRLK_WORLD_47
    WORLD_48 = blindstation.cblind.BRLK_WORLD_48
    WORLD_49 = blindstation.cblind.BRLK_WORLD_49
    WORLD_50 = blindstation.cblind.BRLK_WORLD_50
    WORLD_51 = blindstation.cblind.BRLK_WORLD_51
    WORLD_52 = blindstation.cblind.BRLK_WORLD_52
    WORLD_53 = blindstation.cblind.BRLK_WORLD_53
    WORLD_54 = blindstation.cblind.BRLK_WORLD_54
    WORLD_55 = blindstation.cblind.BRLK_WORLD_55
    WORLD_56 = blindstation.cblind.BRLK_WORLD_56
    WORLD_57 = blindstation.cblind.BRLK_WORLD_57
    WORLD_58 = blindstation.cblind.BRLK_WORLD_58
    WORLD_59 = blindstation.cblind.BRLK_WORLD_59
    WORLD_60 = blindstation.cblind.BRLK_WORLD_60
    WORLD_61 = blindstation.cblind.BRLK_WORLD_61
    WORLD_62 = blindstation.cblind.BRLK_WORLD_62
    WORLD_63 = blindstation.cblind.BRLK_WORLD_63
    WORLD_64 = blindstation.cblind.BRLK_WORLD_64
    WORLD_65 = blindstation.cblind.BRLK_WORLD_65
    WORLD_66 = blindstation.cblind.BRLK_WORLD_66
    WORLD_67 = blindstation.cblind.BRLK_WORLD_67
    WORLD_68 = blindstation.cblind.BRLK_WORLD_68
    WORLD_69 = blindstation.cblind.BRLK_WORLD_69
    WORLD_70 = blindstation.cblind.BRLK_WORLD_70
    WORLD_71 = blindstation.cblind.BRLK_WORLD_71
    WORLD_72 = blindstation.cblind.BRLK_WORLD_72
    WORLD_73 = blindstation.cblind.BRLK_WORLD_73
    WORLD_74 = blindstation.cblind.BRLK_WORLD_74
    WORLD_75 = blindstation.cblind.BRLK_WORLD_75
    WORLD_76 = blindstation.cblind.BRLK_WORLD_76
    WORLD_77 = blindstation.cblind.BRLK_WORLD_77
    WORLD_78 = blindstation.cblind.BRLK_WORLD_78
    WORLD_79 = blindstation.cblind.BRLK_WORLD_79
    WORLD_80 = blindstation.cblind.BRLK_WORLD_80
    WORLD_81 = blindstation.cblind.BRLK_WORLD_81
    WORLD_82 = blindstation.cblind.BRLK_WORLD_82
    WORLD_83 = blindstation.cblind.BRLK_WORLD_83
    WORLD_84 = blindstation.cblind.BRLK_WORLD_84
    WORLD_85 = blindstation.cblind.BRLK_WORLD_85
    WORLD_86 = blindstation.cblind.BRLK_WORLD_86
    WORLD_87 = blindstation.cblind.BRLK_WORLD_87
    WORLD_88 = blindstation.cblind.BRLK_WORLD_88
    WORLD_89 = blindstation.cblind.BRLK_WORLD_89
    WORLD_90 = blindstation.cblind.BRLK_WORLD_90
    WORLD_91 = blindstation.cblind.BRLK_WORLD_91
    WORLD_92 = blindstation.cblind.BRLK_WORLD_92
    WORLD_93 = blindstation.cblind.BRLK_WORLD_93
    WORLD_94 = blindstation.cblind.BRLK_WORLD_94
    WORLD_95 = blindstation.cblind.BRLK_WORLD_95
    KP0 = blindstation.cblind.BRLK_KP0
    KP1 = blindstation.cblind.BRLK_KP1
    KP2 = blindstation.cblind.BRLK_KP2
    KP3 = blindstation.cblind.BRLK_KP3
    KP4 = blindstation.cblind.BRLK_KP4
    KP5 = blindstation.cblind.BRLK_KP5
    KP6 = blindstation.cblind.BRLK_KP6
    KP7 = blindstation.cblind.BRLK_KP7
    KP8 = blindstation.cblind.BRLK_KP8
    KP9 = blindstation.cblind.BRLK_KP9
    KP_PERIOD = blindstation.cblind.BRLK_KP_PERIOD
    KP_DIVIDE = blindstation.cblind.BRLK_KP_DIVIDE
    KP_MULTIPLY = blindstation.cblind.BRLK_KP_MULTIPLY
    KP_MINUS = blindstation.cblind.BRLK_KP_MINUS
    KP_PLUS = blindstation.cblind.BRLK_KP_PLUS
    KP_ENTER = blindstation.cblind.BRLK_KP_ENTER
    KP_EQUALS = blindstation.cblind.BRLK_KP_EQUALS
    UP = blindstation.cblind.BRLK_UP
    DOWN = blindstation.cblind.BRLK_DOWN
    RIGHT = blindstation.cblind.BRLK_RIGHT
    LEFT = blindstation.cblind.BRLK_LEFT
    INSERT = blindstation.cblind.BRLK_INSERT
    HOME = blindstation.cblind.BRLK_HOME
    END = blindstation.cblind.BRLK_END
    PAGEUP = blindstation.cblind.BRLK_PAGEUP
    PAGEDOWN = blindstation.cblind.BRLK_PAGEDOWN
    F1 = blindstation.cblind.BRLK_F1
    F2 = blindstation.cblind.BRLK_F2
    F3 = blindstation.cblind.BRLK_F3
    F4 = blindstation.cblind.BRLK_F4
    F5 = blindstation.cblind.BRLK_F5
    F6 = blindstation.cblind.BRLK_F6
    F7 = blindstation.cblind.BRLK_F7
    F8 = blindstation.cblind.BRLK_F8
    F9 = blindstation.cblind.BRLK_F9
    F10 = blindstation.cblind.BRLK_F10
    F11 = blindstation.cblind.BRLK_F11
    F12 = blindstation.cblind.BRLK_F12
    F13 = blindstation.cblind.BRLK_F13
    F14 = blindstation.cblind.BRLK_F14
    F15 = blindstation.cblind.BRLK_F15
    NUMLOCK = blindstation.cblind.BRLK_NUMLOCK
    CAPSLOCK = blindstation.cblind.BRLK_CAPSLOCK
    SCROLLOCK = blindstation.cblind.BRLK_SCROLLOCK
    RSHIFT = blindstation.cblind.BRLK_RSHIFT
    LSHIFT = blindstation.cblind.BRLK_LSHIFT
    RCTRL = blindstation.cblind.BRLK_RCTRL
    LCTRL = blindstation.cblind.BRLK_LCTRL
    RALT = blindstation.cblind.BRLK_RALT
    LALT = blindstation.cblind.BRLK_LALT
    RMETA = blindstation.cblind.BRLK_RMETA
    LMETA = blindstation.cblind.BRLK_LMETA
    LSUPER = blindstation.cblind.BRLK_LSUPER
    RSUPER = blindstation.cblind.BRLK_RSUPER
    MODE = blindstation.cblind.BRLK_MODE
    COMPOSE = blindstation.cblind.BRLK_COMPOSE
    HELP = blindstation.cblind.BRLK_HELP
    PRINT = blindstation.cblind.BRLK_PRINT
    SYSREQ = blindstation.cblind.BRLK_SYSREQ
    BREAK = blindstation.cblind.BRLK_BREAK
    MENU = blindstation.cblind.BRLK_MENU
    POWER = blindstation.cblind.BRLK_POWER
    EURO = blindstation.cblind.BRLK_EURO
    BACKWARD = blindstation.cblind.BRLK_BACKWARD
    FORWARD = blindstation.cblind.BRLK_FORWARD
    DOT7 = blindstation.cblind.BRLK_DOT7
    DOT8 = blindstation.cblind.BRLK_DOT8
    ACCORD_a = blindstation.cblind.BRLK_ACCORD_a
    ACCORD_b = blindstation.cblind.BRLK_ACCORD_b
    ACCORD_c = blindstation.cblind.BRLK_ACCORD_c
    ACCORD_d = blindstation.cblind.BRLK_ACCORD_d
    ACCORD_e = blindstation.cblind.BRLK_ACCORD_e
    ACCORD_f = blindstation.cblind.BRLK_ACCORD_f
    ACCORD_g = blindstation.cblind.BRLK_ACCORD_g
    ACCORD_h = blindstation.cblind.BRLK_ACCORD_h
    ACCORD_i = blindstation.cblind.BRLK_ACCORD_i
    ACCORD_j = blindstation.cblind.BRLK_ACCORD_j
    ACCORD_k = blindstation.cblind.BRLK_ACCORD_k
    ACCORD_l = blindstation.cblind.BRLK_ACCORD_l
    ACCORD_m = blindstation.cblind.BRLK_ACCORD_m
    ACCORD_n = blindstation.cblind.BRLK_ACCORD_n
    ACCORD_o = blindstation.cblind.BRLK_ACCORD_o
    ACCORD_p = blindstation.cblind.BRLK_ACCORD_p
    ACCORD_q = blindstation.cblind.BRLK_ACCORD_q
    ACCORD_r = blindstation.cblind.BRLK_ACCORD_r
    ACCORD_s = blindstation.cblind.BRLK_ACCORD_s
    ACCORD_t = blindstation.cblind.BRLK_ACCORD_t
    ACCORD_u = blindstation.cblind.BRLK_ACCORD_u
    ACCORD_v = blindstation.cblind.BRLK_ACCORD_v
    ACCORD_w = blindstation.cblind.BRLK_ACCORD_w
    ACCORD_x = blindstation.cblind.BRLK_ACCORD_x
    ACCORD_y = blindstation.cblind.BRLK_ACCORD_y
    ACCORD_z = blindstation.cblind.BRLK_ACCORD_z
    LAST = blindstation.cblind.BRLK_LAST
