#! /usr/bin/python

from xml.dom.minidom import Document,parse
from string import strip

from blindstation.utils import BSError



class helpTree:

  def __init__ (self):

    self.tree = {}
    self.current = 'main'
    self.createTree()


  def getCurrent (self):
    return self.current


  def getParent (self):
    return self.tree[self.current]['parent']


  def getFils (self):
    return self.tree[self.current]['fils']


  def getType (self):
    return self.tree[self.current]['type']


  def getSound (self):
    return self.tree[self.current]['sound']


  def getTree (self):
    return self.tree
  

  def goToParent (self):
    name = self.getParent()
    if name != '':
      self.current = name
    return self.current
  

  def goToFils (self, link):
    self.current = link
    

  def createTree (self):
    self.createMain()
    self.createGeneral()
    self.createConcepts()
    self.createNavigation()
    self.createSound()
    

  def createMain (self):
    listSounds = ['mh01', 'mh03', 'mh22', 'mh31', 'mh0B']
    listLinks = ['general', 'concepts', 'navigation', 'soundex', '']

    self.tree['main'] = {}
    self.tree['main']['type'] = 'menu01'
    self.tree['main']['parent'] = ''
    self.tree['main']['fils'] = []

    for it in range(len(listSounds)):
      self.tree['main']['fils'].append({'name':'HelpM1_'+`it`,'sound':listSounds[it],'link':listLinks[it]})


  def createGeneral (self):
    self.tree['general'] = {}
    self.tree['general']['type'] = 'content01'
    self.tree['general']['parent'] = 'main'
    self.tree['general']['sound'] = 'mh02'


  def createConcepts (self):
    listLinks = ["menunav", "worlds", "levels", "life", "extralife", "monsters",
                 "mud", "bosses", "bonuso", "blo", "bonlevels", "score",
                 "timebonus", "highscore", "watercont", "pause", "save", "sonixes"]
    
    listSounds = ['mh04a', 'mh05a', 'mh06a', 'mh07a', 'mh08a', 'mh09a',
                  'mh10a', 'mh11a', 'mh12a', 'mh13a', 'mh14a', 'mh15a', 
                  'mh16a', 'mh17a', 'mh18a', 'mh19a', 'mh20a', 'mh21a']
    
    listSoundsLinks = ['mh04b', 'mh05b', 'mh06b', 'mh07b', 'mh08b', 'mh09b',
                       'mh10b', 'mh11b', 'mh12b', 'mh13b', 'mh14b', 'mh15b', 
                       'mh16b', 'mh17b', 'mh18b', 'mh19b', 'mh20b', 'mh21b']

    self.tree['concepts'] = {}
    self.tree['concepts']['type'] = 'menu02'
    self.tree['concepts']['parent'] = 'main'
    self.tree['concepts']['fils'] = []

    for it in range(len(listLinks)):
      if it <= 8:
        self.tree['concepts']['fils'].append({'name':'HelpM2_'+`it`,'sound':listSounds[it],'link':listLinks[it]})
      else:
        self.tree['concepts']['fils'].append({'name':'HelpM2_'+`it+1`,'sound':listSounds[it],'link':listLinks[it]})
      self.tree[listLinks[it]] = {}
      self.tree[listLinks[it]]['type'] = 'content02'
      self.tree[listLinks[it]]['parent'] = 'concepts'
      self.tree[listLinks[it]]['sound'] = listSoundsLinks[it]


  def createNavigation (self):
    listLinks = ["movement", "water_spurting", "monster_hitting", "mud_throwing",
                 "saving", "winning", "losing", "statistics", "shortcuts"]

    listSounds = ['mh23a', 'mh24a', 'mh25a', 'mh26a',
                  'mh27a', 'mh28a', 'mh29a', 'mh30a', 'mh64a']
    
    listSoundsLinks = ['mh23b', 'mh24b', 'mh25b', 'mh26b',
                       'mh27b', 'mh28b', 'mh29b', 'mh30b', 'mh64b']
    
    self.tree['navigation'] = {}
    self.tree['navigation']['type'] = 'menu02'
    self.tree['navigation']['parent'] = 'main'
    self.tree['navigation']['fils'] = []

    for it in range(len(listLinks)):
      self.tree['navigation']['fils'].append({'name':'HelpM2_'+`it`,'sound':listSounds[it],'link':listLinks[it]})

      self.tree[listLinks[it]] = {}
      self.tree[listLinks[it]]['type'] = 'content02'
      self.tree[listLinks[it]]['parent'] = 'navigation'
      self.tree[listLinks[it]]['sound'] = listSoundsLinks[it]


  def createSound (self):
    listLinks = ["step", "wallbump", "spurt", "emptywater",
                 "hit3", "hit2", "hit1",
                 "hit1l", "boss1hit", "boss1killed", "throw750B",
                 "splat", "1life", "bonus", "extralifehit", "bombhit",
                 "uwaterhit", "doublemscorehit", "pointshit", "bonuslo",
                 "bonuslevelobjhit", "+bounce1", "-bounce1", "hit11", "hit12"]

    listSounds = []
    listSounds.extend(['mh32','mh33','mh34'])
    listSounds.extend(['mh36','mh37','mh38','mh39','mh42','mh41','mh40','mh43','mh44','mh45'])
    listSounds.extend(['mh49','mh50','mh51','mh52','mh53','mh54','mh55','mh56'])
    listSounds.extend(['mh59','mh60','mh61','mh62'])

    self.tree['soundex'] = {}
    self.tree['soundex']['type'] = 'menu03'
    self.tree['soundex']['parent'] = 'main'
    self.tree['soundex']['fils'] = []

    for it in range(len(listLinks)):
      self.tree['soundex']['fils'].append({'name':'HelpM3_'+`it`,'sound':[listSounds[it],listLinks[it]],'link':listLinks[it]})

      self.tree[listLinks[it]] = {}
      self.tree[listLinks[it]]['type'] = None
      self.tree[listLinks[it]]['parent'] = 'soundex'
      self.tree[listLinks[it]]['sound'] = listLinks[it]
