#! /usr/bin/python

from time import time
from random import uniform,choice

from blindstation import *
from blindstation.utils import BSError

from myBStools import myMenu,sayNumbersClass
from os.path import exists
from os import remove, mkdir

from msobjects import Player
from version import versionNb, devMode

from mLevels import monsterList, bossList, bonusList

# Notes
#
# Positions sont toujours positives, calculees de 0 a width-1


#-- ----------------------------------------------------

class MainSc(myMenu):

  def __init__(self, parent, gameInfo):
    myMenu.__init__(self,parent,'main','init')

    self.gameInfo=gameInfo

    self.player=Player()

    self.status=0
    # status=0: start
    # status=1: wait to start
    # status=2: play
    # status=3: paused
    # status=4: loose 1 live
    # status=5: game over
    # status=6: completed one level, go to  next
    # status=7: starting a new level (almost like status 0)

    self.gameStatus=0
    # gameStatus=0: not started
    # gameStatus=1: monsters
    # gameStatus=2: wait for boss monsters to appear (all other monsters killed)
    # gameStatus=3: boss monsters is here
    # gameStatus=4: boss monster was killed
    
    # Settings of the level
    self.initLevel()

    # Save Rescue file and Auto Save
    self.gameInfo.saveRescueFile()
    self.gameInfo.autoSaveGame()

    #
    # Creation of Timers
    # ------------------------------------------------------------
    self.tempoTmx = Timer(self,"_Tmx.tempo")
    self.tempoTmx.timer_callback = self.oneStepTempo

    self.msTempoTmx = Timer(self,"_Tmx.monstertempo")
    self.msTempoTmx.timer_callback = self.oneStepMonsterTempo
    self.msTempoValue=self.level.tempo/self.level.nbMaxMonsters

    # Case of limited time
    self.remainingTime=self.gameInfo.getRemainingTime()
    if self.remainingTime!=None:
      self.timeLimitTmx=Timer(self,"_Tmx.timeLimit")
      self.timeLimitTmx.timer_callback = self.cbTimeLimit


    #
    # Design of the Scene
    # ------------------------------------------------------------

    self.state = self.level.world
    self.BTitle=Widget(self,'_Title','init')
    self.BTitle.state = self.level.world

    # For myMenu
    self.addMenuItem('_Fire','init',cb=None,voiceFile='resumeGame')
    self.menuButton('_Fire').hidden = True
    self.addMenuItem('_Esc','init',cb=None,voiceFile='cancelGame')
    self.menuButton('_Esc').hidden = True
    self.setTickSound('menutick')
    self.setTopBottomSounds('menutopdown')

    self.BSCORE=Widget(self,'_SCORE','std')
    self.BSCORE.validate_callback=None
    self.BSCORE.hidden = True

    self.zoom_widget = Widget(self, 'zoom', 'init')
    self.zoom_widget.hidden = True

####    self.BTMPA=myButton(self.back,self.Resource('TMP1'),'off2')
####    if self.show==1: self.BTMPA.setStatus('on2')

####    self.BVOLPLUS=myButton(self.back,self.Resource('_VolPlus'),'std')
####    self.BVOLPLUS.pyattach(self.__class__.cbIncVolume,self)
####    self.BVOLMOINS=myButton(self.back,self.Resource('_VolMoins'),'std')
####    self.BVOLMOINS.pyattach(self.__class__.cbDecVolume,self)

    #
    # Creation of sound sources
    # ------------------------------------------------------------

    self.sndSourceSteps=Source(self,'Steps')
    self.sndSourceSteps.queue('step')

    self.sndSourceWallbump=Source(self,'Wallbump')
    self.sndSourceWallbump.setSurround(1)
    self.sndSourceWallbump.queue('wallbump')

    self.sndSourceBgsound=Source(self,'Background Sound')
    self.sndSourceBgsound.setLooping(1)

    self.sndSourceBonus=Source(self,'Bonus')
    self.sndSourceBonus.setSurround(1)

    self.sndSourcePlayerFire=Source(self,'PlayerFire')
    self.sndSourceMonsterFire=Source(self,'MonsterFire')

    # Monsters sources are created.
    self.sndSources={}
    for m in self.level.monsters: 
      self.sndSources[monsterList[m].name]=Source(self,monsterList[m].name)
      self.sndSources[monsterList[m].name].setSurround(1)
      self.sndSources[monsterList[m].name].queue(monsterList[m].wavname)

    if self.theBoss!=None:
      self.sndSourceBoss=Source(self,'Boss')
      self.sndSourceBoss.setSurround(1)

    self.sayNumbersEngine=sayNumbersClass()

    self.playIntro()


  def launchCallback (self, name):
    name = self.selectedItem
    if name == '_Fire':
      self.cbFireButton(name,None,None)
    elif name == '_Esc':
      self.cbEsc(name,None,None)
    elif name == '_SAVE':
      self.cbSave(name,None,None)
    elif name == '_STATS':
      self.cbStats(name,None,None)
    elif name == '_HELP':
      print "Aide non disponible"
      

  def playIntro(self):

    self.sndSourceMessages.empty()
    if devMode==2:
      self.sndSourceMessages.queue('1life')

    else: # Normal case
      if self.status in [0,7]:
        if self.level.bonusLevel==0:
          self.sndSourceMessages.queue(self.level.world)
          self.sndSourceMessages.queue(self.level.levelnum)
          self.sndSourceMessages.queue('newlevel')
        else:
          self.sndSourceMessages.queue('startbonuslevel')

      elif self.status==4:
        self.sndSourceMessages.queue('restart')
        self.sndSourceMessages.queue('restartlevel')

      else:
        raise BSError, 'Problem, should never arrive in there !'
        
      if self.level.bonusLevel==0:
        for i in range(self.lives-1):
          self.sndSourceMessages.queue('1life')

    self.sndSourceMessages.source_callback=self.sceneReady
    self.sndSourceMessages.play()


  def sceneReady(self,name):
    self.sndSourceMessages.source_callback=None
    self.menuButton('_Fire').hidden = True #self.menuButton('_Fire').state='hidden'
    self.menuButton('_Esc').hidden = True #self.menuButton('_Esc').state='hidden'
    self.setCallback('_Fire',"Yes")
    self.setCallback('_Esc',"Yes")
    self.BSCORE.validate_callback=self.cbSayScore
    self.startLoop()
    self.status=2
    self.objectShotMode=0


  #-- Initialisations --------------------------------------------------

  def initLevel(self):
    self.levelname=self.gameInfo.getLevelName()
    self.level=self.gameInfo.getLevel()

    self.score=self.gameInfo.getScore()
    self.score_level=0

    self.lives=self.gameInfo.getLives()
    self.nbMonstersDefeated=self.gameInfo.getNbMonstersDefeated()
    self.nbLevelsCompleted=self.gameInfo.getNbLevelsCompleted()
    self.nbLevelObjects=self.gameInfo.getNbLevelObjects()

    if self.gameInfo.getNewlevel == 1:
      self.status=7

    self.width=self.level.width
    self.halfwidth=self.width/2

    self.reInitLevel()

  def reInitLevel(self):
    # Information to be saved
    self.cctempo=0
    self.ccmtempo=0
    self.nbMonstersAppeared=0
    self.nbKilled=0
    # warning in bonus level, self.nbKilled increases when a bonus is missed 

    self.waterContainer=self.level.waterContainerSize
    self.unlimitedWater=0

    self.nbLevelObjects=self.gameInfo.getNbLevelObjects()

    self.availableBonuses=[]
    self.theBonus=None
    self.theBoss=None
    # Inititalisation of work parameters of objects
    # To be saved also
    self.scoreMult=self.level.scoreMult
    self.scoreMultBonus=1
    self.timeBonus=self.level.monsterDelay*self.level.nbtokill

    for m in self.level.monsters:
      monsterList[m].eInit(self.level.monsterDelay)

    for bb in self.level.bonus:
      bonusList[bb[0]].eInit()
      self.availableBonuses.extend([bb[0]]*bb[1])

    if self.level.bossMonster!=None:
      self.theBoss = self.level.bossMonster
      for bs in self.level.bossMonster:
        bossList[bs].eInit(self.level.monsterDelay)

    # Information calculated form other
    self.monsterline=[None for i in range(self.width)]
    self.msTempoPositions=[None]*self.level.nbMaxMonsters
    self.nbMonstersPresent=0
    self.throwfile='throw'+self.level.throw

    self.player.setPlace(self.halfwidth)

    # Information to start allways the same
    self.monsterWaitDelay=0
    self.gameStatus=1
    self.objectShot=None
    self.monsterWhichShoots=None
    self.playerWhenMonsterShoots=-1


  #-- CallBacks -------------------------------------------------------
  def cbEsc(self,name,type,key):
    if self.status in [1,3,4]:
      # Cancel the game
      self.gameInfo.removeRescueFile()
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('menuback')
      self.sndSourceMessages.source_callback=self.cbBackToMenu
      self.sndSourceMessages.play()

    elif self.status==2:
      # Pause the game and display a menu
      if not self.player.isShooting and self.monsterWhichShoots==None:
        self.status=3
        self.enterPauseMode()

    # if self.status=0, il faut arreter les sons avant (peut-etre dans tous les cas?)
    return self.status

  def cbBackToMenu(self,name):
    self.sndSourceMessages.source_callback=None
    self.sndSources.clear()
    self.next = self.gameInfo.getScene('menu')
    self.nextargs=[self.gameInfo]

  def cbFireButton(self,name,type,key):
    if self.status==2:
      self.playerFires()
      
    elif self.status in [1,3,4]:
      # 1: Start game
      # 3: Resume game after pause
      # 4: Resume game after loose 1 level
      self.endPauseMode()
      
    return self.status

  def cbSayScore(self,name,type,key):
    if self.status == 2:
      phrase=self.getSentenceToSay(self.score)
      if phrase!=[]:
        self.sndSourceMessages.empty()
        for mot in phrase: self.sndSourceMessages.queue(mot)
        self.sndSourceMessages.source_callback=None
        self.sndSourceMessages.play()        
    return 0

  def getSentenceToSay(self,num):
    phrase=self.sayNumbersEngine.tospeech1e6(num,self.lang)
    if phrase!='overflow': return map(lambda c:c[1],phrase)
    return []

  #-- Change scene mode (play/pause) -----------------------------------

  def enterPauseMode(self):
    if self.status==3:
      self.suspendLoop()
      self.state='pause'
      self.BTitle.state='pause'

      self.addMenuItem('_SAVE','pausemenu',"Yes",pos=1,voiceFile='saveGame')
      self.addMenuItem('_STATS','pausemenu',"Yes",pos=2,voiceFile='statsGame')

      self.menuButton('_Fire').hidden = False
      self.menuButton('_Esc').hidden = False
      self.menuButton('_Fire').state='pausemenu'
      self.menuButton('_Esc').state='pausemenu'
      self.addMenuItem('_HELP','pausemenu',None,pos=3,voiceFile='helpGame')

####    # Hidden buttons (tmporary features)
####    self.BTMP2=myButton(self.back,self.Resource('_FLAGTMPSHOW'),'std')
####    self.BTMP2.pyattach(self.__class__.cbTMPShow,self)

####    if self.show==1:     self.BTMPA.state='on'
####    else:                self.BTMPA.state='off'

    self.sndSourceMessages.empty()
    self.sndSourceMessages.queue('pause')
    self.sndSourceMessages.source_callback=self.cbVoicePause
    self.sndSourceMessages.play()

  def cbVoicePause(self,name):
    #self.sndSourceMessages.stop()
    self.sndSourceMessages.empty()
    self.sndSourceMessages.source_callback=None
    
    self.set_focus(self.findFocusIndex(self.Order[0]))
    self._menustatus=1

  def endPauseMode(self):
    self.state=self.level.world
    self.BTitle.state=self.level.world
    
    self.focus = self.BTitle.__id__

    if self.status==3:
      self.removeMenuItem('_SAVE')
      self.removeMenuItem('_STATS')
      self.removeMenuItem('_HELP')

    self.menuButton('_Fire').hidden = True #self.menuButton('_Fire').state='hidden'
    self.menuButton('_Esc').hidden = True #self.menuButton('_Esc').state='hidden'
    
      
####    del self.BTMP2

####    if self.show==1:     self.BTMPA.state='on2'
####    else:                self.BTMPA.state='off2'

    self.status=2
    self.startLoop()


  #-- Save a game ------------------------------------------------------
  def cbSave(self,name,type,key):
    self.status=8  ## Probablement inutile, a voir

    if self.score == 0:
      self.score = -1

    self.state=self.level.world
    self.BTitle.state=self.level.world
    self.focus = self.BTitle.__id__

    self.gameInfo.setScore(self.score)
    self.gameInfo.removeRescueFile()
    self.sndSources.clear()
    
    self.next = self.gameInfo.getScene('saveload')    
    self.nextargs=[self.gameInfo]


  #-- Start/Stop loop --------------------------------------------------
  def startLoop(self):
    self.zoom_widget.validate_callback = None
    self.navig.key = KeyCode.SPACE
    if self.gameInfo.show:
      self.BTMPZA=Widget(self,'ZPlayers','init')
      self.updateDisplayPlayer()
      self.BTMPZB=Widget(self,'ZMonsters','init')
      self.updateDisplayMonsters()

    if self.level.bgsound!=None:
      self.sndSourceBgsound.empty()
      self.sndSourceBgsound.queue(self.level.bgsound)
      self.sndSourceBgsound.play()

    self.tempoTmx.setTime(self.level.tempo)
    self.msTempoTmx.setTime(self.msTempoValue)

    if self.remainingTime!=None:
      self.timeLimitTmx.setTime(self.remainingTime)
      self.startTime=time()

    self.player.startLoop()
    return 0
  
  def suspendLoop(self):
    self.zoom_widget.validate_callback = self.zoom_callback
    self.navig.key = KeyCode.RETURN
    if self.remainingTime!=None:
      self.timeLimitTmx.setTime(0)
      self.remainingTime-=int(time()-self.startTime)*1000
      self.gameInfo.setRemainingTime(self.remainingTime)

    if self.level.bgsound!=None:
      self.sndSourceBgsound.stop()
    self.player.suspendLoop()
    self.tempoTmx.setTime(0)
    self.msTempoTmx.setTime(0)
    
    if self.gameInfo.show:
      self.BTMPZA.hidden = True
      self.BTMPZB.hidden = True

    return 0

  
  #-- Main tempo loop --------------------------------------------------
  def oneStepTempo(self,name):
    if self.status==2: # Check is game is running (should not be absolutly necessary...)
      self.cctempo+=1

      self.monsterWaitDelay+=1
      if self.cctempo%self.level.waterRefillDelay==0 and self.waterContainer<self.level.waterContainerSize:
        self.waterContainer+=self.level.waterRefillUnits


      ########################################################################
      #   Moves
      #
      # Moves are performed before creation of object so that objects just created will move
      # next step only

      # -- ---- Moves (bonus)
      if self.theBonus!=None: # bonus should move
        newBonusPos=self.theBonus.cpos+self.theBonus.direction
        if newBonusPos>=0 and newBonusPos<=self.width-self.theBonus.width:
          self.theBonus.setPlace(newBonusPos)
        else:
          self.theBonus.disappears()
          self.theBonus=None

      # -- ---- Moves (boss)
      if self.gameStatus==3:
        if (self.theBoss.avoidPlayer\
            and self.theBoss.cpos+self.theBoss.direction*self.theBoss.moveDist==self.player.position)\
            or self.myProba(self.theBoss.probaToTurn):
          self.theBoss.direction=-self.theBoss.direction
        newBossPos=self.theBoss.cpos+self.theBoss.direction*self.theBoss.moveDist
        if (newBossPos<0) or (newBossPos>self.width-self.theBoss.width):
          self.theBoss.direction=-self.theBoss.direction
          newBossPos=self.theBoss.cpos+self.theBoss.direction*self.theBoss.moveDist

          # ne traite pas le cas ou il peut essayer d'eviter le joueur

        for i in range(self.theBoss.width):
          self.monsterline[self.theBoss.cpos+i]=None
        self.theBoss.setPlace(newBossPos)
        for i in range(self.theBoss.width):
          self.monsterline[self.theBoss.cpos+i]=self.theBoss


      ########################################################################
      #   OBJECTS APPEAR
      #
      
      # -- ---- Check if monster may appear
      if self.objectShotMode==0 and self.gameStatus==1 and self.nbMonstersPresent<self.level.nbMaxMonsters and \
             self.nbKilled + self.nbMonstersPresent<self.level.nbtokill and \
             ( (self.nbMonstersPresent==0 and self.monsterWaitDelay>=self.level.monsterMaxWait) \
               or (self.nbMonstersPresent==0 and self.myProba(self.level.probaMonster1)) \
               or (self.nbMonstersPresent==1 and self.myProba(self.level.probaMonster2)) \
               or self.myProba(self.level.probaMonster)) :
        
        whatMonster=self.chooseMonster()
        
        if whatMonster!=None:
          monsterPos=self.choosePosition(whatMonster.width)
          if monsterPos<0: whatMonster=None

        if whatMonster!=None:
          self.nbMonstersPresent+=1
          self.nbMonstersAppeared+=1
          whatMonster.preparesToAppear(monsterPos)
          #print "The monster", self.nbMonstersAppeared, "appears"
          i=0
          while i<self.level.nbMaxMonsters and self.msTempoPositions[i]!=None: i+=1
          if i!=self.level.nbMaxMonsters:
            self.msTempoPositions[i]=whatMonster
          else:
            print "positions: ",self.msTempoPositions
            raise BSError, 'Impossible, should never happen !!'

      # -- ---- Check if boss may appear
      elif self.objectShotMode==0 and self.gameStatus==2 and self.theBoss.canAppear:

        print "Boss Monster appears"
        self.gameStatus=3
        
        self.nbMonstersPresent+=1
        self.nbMonstersAppeared+=1
        for i in range(self.theBoss.width):
          self.monsterline[self.theBoss.appearingPosition+i]=self.theBoss
        self.theBoss.appears()

      # -- ---- Check if bonus may appear
      elif self.objectShotMode==0 and self.gameStatus==1 and self.theBonus==None:
        # bonus should not appear if boss is here
        # only if no monster has already appeared this time
        tmpBonusDir=[]
        if self.monsterline[0]==None: tmpBonusDir.append(0)
        if self.monsterline[self.width-1]==None: tmpBonusDir.append(self.width)
        
        if len(tmpBonusDir)>0 and len(self.availableBonuses)>0:
          b=None
          if ('BL' in self.availableBonuses) and (self.level.nbtokill-self.nbKilled<=2):
            b='BL'
          elif self.myProba(self.level.probaBonus):
            b=choice(self.availableBonuses)

          if b!=None:
            self.availableBonuses.remove(b)

            self.theBonus=bonusList[b]
            self.theBonus.preparesToAppear(choice(tmpBonusDir))
            self.theBonus.appears()
            self.sndSourceBonus.empty()
            self.sndSourceBonus.queue(self.theBonus.bounce)


      ########################################################################
      #   SOUNDS
      #
      
      # -- ---- Sounds (bonus & bosses ; monsters are played in oneStepMonsterTempo)
      if self.theBonus!=None:
        if self.sndSourceBonus.isPlaying():
          self.sndSourceBonus.stop()
        pos=self.theBonus.sndPosition(self.player.position)
        self.sndSourceBonus.setPosition(-pos[0],pos[1],pos[2])
        self.sndSourceBonus.play()

      if self.gameStatus==3:
        if self.sndSourceBoss.isPlaying():
          self.sndSourceBoss.stop()
        pos=self.theBoss.sndPosition(self.player.position)
        self.sndSourceBoss.setPosition(-pos[0],pos[1],pos[2])
        self.sndSourceBoss.play()

        
      ########################################################################
      #   MONSTER SHOTS
      #
      # Monsters (including bosses) may shot after their 'delayToFireSrc' tempo steps
      # they cannot shoot if the player is shooting, or if another one shots
      # in the case of normal monsters they disappear if they miss
      
      # -- Monster Shots: ---> moved in 'oneStepMonsterTempo'
      
      # -- Boss Monster Shots -> not like monsters !
      # Check if this monster should shoot
      if self.gameStatus==3:
        if (self.monsterWhichShoots==None and not self.player.isShooting and self.theBoss.canFire
            and self.myProba(self.theBoss.probaToFire)):
          self.monsterWhichShoots=self.theBoss
          self.monsterWhichShoots.fires()
          self.playerWhenMonsterShoots=self.player.position

          self.sndSourceMonsterFire.empty()
          self.sndSourceMonsterFire.queue(self.throwfile)
          self.sndSourceMonsterFire.source_callback=self.monsterShotCompleted
          self.sndSourceMonsterFire.play()


      ########################################################################
      #   TEMPO UPDATES
      #

      # -- Updates of monsters objects (including bosses if needed)  
      for item in self.level.monsters:
        monsterList[item].tempoUpdate()
      if self.gameStatus in [2,3]: self.theBoss.tempoUpdate()


      ########################################################################
      #   END
      #
      
      if self.gameInfo.show: self.updateDisplayMonsters()
      return 1
    
    return 0

  #-- ------------------------------------------------------------------
  def myProba(self,pc):
    if uniform(0,100)<pc*1.0: return 1
    return 0

  def chooseMonster(self):
    lst=[m for m in self.level.monsters if monsterList[m].canAppear]
    if len(lst)==0:
      print "No monster available"
      return None
    return monsterList[choice(lst)]

  def choosePosition(self,mSize):
    tmp=[]
    for i in range(self.width-(mSize-1)):
      sum=0
      for j in range(-1,mSize+1):
        if i+j in range(self.width):
          if i+j==self.player.position \
                 or self.monsterline[i+j]!=None \
                 or (self.theBonus!=None and i+j==self.theBonus.cpos):
            sum+=1
      if sum==0:
        tmp.append(i)
    if tmp==[]: return -1
    return choice(tmp)

  #-- Secondary loop (monsters voices) ---------------------------------
  def oneStepMonsterTempo(self,name):
    if self.status==2: # Check if game is running (should not be absolutly necessary...)
      self.ccmtempo+=1
      monster=self.msTempoPositions[self.ccmtempo%self.level.nbMaxMonsters]

      if monster!=None:

        if monster.isReadyToAppear():
          monster.appears()
          for i in range(monster.width):
            self.monsterline[monster.cpos+i]=monster
            if self.gameInfo.show: self.updateDisplayMonsters()
  
        if monster.isPresent():
          pos=monster.sndPosition(self.player.position)
          self.sndSources[monster.name].stop()
          self.sndSources[monster.name].setPosition(-pos[0],pos[1],pos[2])
          self.sndSources[monster.name].play()

          if self.timeBonus>0: self.timeBonus-=1
  
          # Check if this monster should shoot
          if self.level.bonusLevel==0 and\
                 self.monsterWhichShoots==None and\
                 not self.player.isShooting and monster.canFire:
            self.monsterWhichShoots=monster
            self.monsterWhichShoots.fires()
            self.playerWhenMonsterShoots=self.player.position
  
            self.sndSourceMonsterFire.empty()
            self.sndSourceMonsterFire.queue(self.throwfile)
            self.sndSourceMonsterFire.source_callback=self.monsterShotCompleted
            self.sndSourceMonsterFire.play()
         
          # Check if this bonus level monsters should disappear
          if self.level.bonusLevel==1 and\
                 not self.player.isShooting and monster.canFire:
            print "Remove monster in oneStepMonsterTempo"
            self.removeMonster(monster)
            self.nbKilled+=1
            if self.nbKilled >= self.level.nbtokill:
              self.levelCompleted()
    return 0


  #-- Moves ------------------------------------------------------------
  def navigator_callback(self,dir):
####    if dir >= Navigator.BUTTON:
####      return self.cbFireButton('navigator')

    if self.status in [1,3,4]:
      myMenu.navigator_callback(self,dir)
    
    elif self.status==2:
      if self.player.canMove and dir.x<0:
        if self.player.position>0: self.moveTo(self.player.position-1)
        else: self.bumpWall(self.player.position-1)
        
      elif self.player.canMove and dir.x>0:
        if self.player.position<self.width-1:  self.moveTo(self.player.position+1)
        else: self.bumpWall(self.player.position+1)

      elif dir.y>0:
        if devMode!=0:
          self.levelCompleted()

      elif dir.y<0:
        if devMode!=0:
          self.suspendLoop()
          self.looseOneLife('TEMPORARY')

  def moveTo(self,newpos):
    self.player.moveTo(newpos)
    self.sndSourceSteps.play()
    if self.gameInfo.show: self.updateDisplayPlayer()

  def bumpWall(self,wallposition):
    self.sndSourceWallbump.stop()
    self.sndSourceWallbump.setPosition(-wallposition,0,0)
    self.sndSourceWallbump.play()
    return 0
  
  #-- Player fires -----------------------------------------------------
  def playerFires(self):
    if self.player.canShot and self.objectShot==None:
      
      if self.unlimitedWater==1 or self.waterContainer>0:
        
        self.player.fires()
        if self.unlimitedWater==0: self.waterContainer-=1
        
        self.sndSourcePlayerFire.empty()
        
        if self.monsterline[self.player.position]!=None:
          #[Player fires] Monster hit
          self.objectShot=self.monsterline[self.player.position]
          if self.gameStatus==1:
            self.sndSourceMonsterFire.stop()
            self.nbKilled+=1
            if self.nbKilled==self.level.nbtokill and self.theBoss==None:
              self.sndSourcePlayerFire.queue(self.objectShot.hitSound(last=1))
            else:
              self.sndSourcePlayerFire.queue(self.objectShot.hitSound())
            #self.eraseObject()
            
          elif self.gameStatus==3:
            self.sndSourceBoss.stop()
            # Boss monster was hit because in this case it must be the only
            # one in self.monsterline
            if self.objectShot.hitted() == 0:
              self.sndSourcePlayerFire.queue(self.theBoss.hitwavname)
              self.objectShot=None 
            else:
              self.sndSourcePlayerFire.queue(self.theBoss.killedwavname) 
            #self.gameStatus=4
            #self.eraseObject()
        
          else:
            self.playerFireCompleted('')
            
        elif self.theBonus!=None and self.theBonus.cpos==self.player.position:
          #[Player fires] Bonus hit

          if self.theBonus.kind=='B':
            if self.gameStatus==3:  # Boss monster was hit
              if self.theBoss.dieNext():
                self.sndSourcePlayerFire.queue('bombhitlastboss')
              else:
                self.sndSourcePlayerFire.queue('bombhitboss')
            else:
              nbm=0
              last=None
              for m in self.level.monsters:
                if monsterList[m].isPresent() or monsterList[m].isReadyToAppear():
                  nbm+=1
              if self.nbKilled+nbm>=self.level.nbtokill:
                self.sndSourcePlayerFire.queue('bombhitlastmonsters')
              elif nbm>0:
                self.sndSourcePlayerFire.queue('bombhitmonsters')
              else:
                self.sndSourcePlayerFire.queue('bombhit')
          else:
            self.sndSourcePlayerFire.queue(self.theBonus.hitwav)

          self.objectShot=self.theBonus
          self.theBonus.direction=0
          self.eraseObject()
        
        else:
          #[Player fires] Missed !!
          self.sndSourcePlayerFire.queue('spurt')
        
        if self.objectShot != None:
          self.objectShotMode = 1 
          self.eraseObject()
        else:
          self.objectShotMode = 0
        self.sndSourcePlayerFire.source_callback=self.playerFireCompleted
        self.sndSourcePlayerFire.play()

      else: # container vide
        self.sndSourcePlayerFire.stop()
        self.sndSourcePlayerFire.empty()
        self.sndSourcePlayerFire.queue('emptywater')
        self.sndSourcePlayerFire.source_callback=None
        self.sndSourcePlayerFire.play()
  
    #else self.player.canShot is false, nothing to do
    
  def playerFireCompleted(self,name):
    self.objectShotMode = 0
    self.player.fireCompleted()
    if self.gameStatus == 3 and self.objectShot != None: 
      self.sndSourceBoss.play()
    elif self.gameStatus == 4:
      self.levelCompleted()

  #-- ------------------------------------------------------------------
  def eraseObject(self):
    if self.objectShot==self.theBonus:
      print "Erase a bonus"
      self.addToScore(self.objectShot.score,'B')

      if self.theBonus.kind=='EL':
        self.lives+=1

      elif self.theBonus.kind=='BL':
        self.nbLevelObjects+=1

      elif self.theBonus.kind=='UW':
        self.unlimitedWater=1
        while self.availableBonuses.count('UW')>0:
          self.availableBonuses.remove('UW')
          self.availableBonuses.append('EP')
        
      elif self.theBonus.kind=='SM':
        self.scoreMultBonus+=1
        #while self.availableBonuses.count('SM')>0:
        #  self.availableBonuses.remove('SM')
        #  self.availableBonuses.append('EP')

      elif self.theBonus.kind=='B':
        if self.gameStatus==3: # there is a Boss
          if self.theBoss.hitted()>0:
            self.addToScore(self.theBoss.score,'M')
            bossPos=self.theBoss.cpos
            self.removeMonster(self.theBoss)
            self.gameStatus=5

        else:
          self.sndSourceMonsterFire.stop()
          self.sndSourceMonsterFire.source_callback = None
          for m in self.monsterline:
            if m!=None:
              print "Remove monster in monsterline"
              self.removeMonster(m)
              self.addToScore(m.score,'M')
              
          for m in self.level.monsters:
            print "Remove monster in self.level.monsters"
            if monsterList[m].isReadyToAppear():
              monsterList[m].cancelIt()
              self.nbKilled+=1
              self.addToScore(monsterList[m].score,'M')

            if monsterList[m].delayToAppear==0:
              monsterList[m].canAppear=0
              monsterList[m].delayToAppear=3
      
      self.theBonus.disappears()
      self.theBonus=None
      
    else:

      print "Erase a monster"
      if self.level.bonusLevel==0:
        self.addToScore(self.objectShot.score,'M')
      else:
        self.addToScore(self.objectShot.score,'B')

      if self.gameStatus==3:
        bossPos=self.objectShot.cpos
        self.gameStatus=5
        
      self.removeMonster(self.objectShot)
      self.monsterWaitDelay=0


    if self.gameStatus==5:
      self.theBossNum+=1
      if self.theBossNum>=len(self.level.bossMonster):
        self.gameStatus=4
      else:
        self.theBoss=bossList[self.level.bossMonster[self.theBossNum]]

        self.theBoss.preparesToAppear(bossPos)
        self.theBoss.canAppear=1
        self.sndSourceBoss.empty()
        self.sndSourceBoss.queue(self.theBoss.wavname)

        self.nbMonstersPresent+=1
        self.nbMonstersAppeared+=1

        for i in range(self.theBoss.width):
          self.monsterline[self.theBoss.appearingPosition+i]=self.theBoss
        self.theBoss.appears()

        self.gameStatus=3

      
    self.objectShot=None

    if self.gameStatus==1 and self.nbKilled>=self.level.nbtokill:
      if self.level.bossMonster==None:
        self.gameStatus=4
        return 1
      else:
        # Boss will appear soon (at next tempo)
        self.theBossNum=0
        self.theBoss=bossList[self.level.bossMonster[self.theBossNum]]
        monsterPos=choice([0,self.width-self.theBoss.width])
        self.theBoss.preparesToAppear(monsterPos)
        self.theBoss.canAppear=0
        self.theBoss.delayToAppear=3
        self.sndSourceBoss.empty()
        self.sndSourceBoss.queue(self.theBoss.wavname)

        print self.level.bgsoundBoss
        # changer la musique de fond s'il y a lieu
        if self.level.bgsoundBoss!=None:
          if self.sndSourceBgsound.isPlaying():
            self.sndSourceBgsound.stop()
          self.sndSourceBgsound.empty()
          self.sndSourceBgsound.queue(self.level.bgsoundBoss)
          self.sndSourceBgsound.setLooping(1)
          self.sndSourceBgsound.play()

        self.msTempoTmx.setTime(0)
        self.gameStatus=2

    return 0

  def removeMonster(self,monster):
    print "In remove monster:", monster
    if self.gameStatus==1:
      self.sndSources[monster.name].stop()
      for i in range(self.level.nbMaxMonsters):
        if self.msTempoPositions[i]==monster:
          print "Remove monster number:", i, "\n", "Number of killed:", self.nbKilled
          self.msTempoPositions[i]=None
    else:
      self.sndSourceBoss.stop()
    for i in range(monster.width):
      self.monsterline[monster.cpos+i]=None
    monster.killed(3)
    print "End of remove monster \n"
    self.nbMonstersPresent -= 1
    

  #-- Score ------------------------------------------------------------
  def addToScore(self,s,kind):
    # kind:
    # M: monster
    # B: bonus (including Bonus Level Objects and Time Bonus)

    m=1
    if   kind=='M':
      m=self.scoreMultBonus
      self.nbMonstersDefeated+=1
    elif kind=='B': m=self.scoreMult

    s=s*m

    self.score+=s
    self.score_level+=s


  #-- Monster shot -----------------------------------------------------
  def monsterShotCompleted(self,name):
    self.sndSourceMonsterFire.source_callback=None
    if abs(self.playerWhenMonsterShoots-self.player.position)<self.level.mudwidth:
      self.player.suspendLoop()
      self.suspendLoop()
      self.suspendCallbacks()

      self.sndSourceMonsterFire.empty()
      self.sndSourceMonsterFire.queue('splat')
      self.sndSourceMonsterFire.source_callback=self.looseOneLife
      self.sndSourceMonsterFire.play()

    elif self.gameStatus==1:
      self.playerWhenMonsterShoots=-1
      if self.monsterWhichShoots in self.msTempoPositions:
        print "Remove monster in monsterShotCompleted"
        self.removeMonster(self.monsterWhichShoots)
      else:
        print "The monster is removed\n"
      self.monsterWaitDelay=0
      self.monsterWhichShoots=None

    elif self.gameStatus==3:
      self.theBoss.missed()
      self.monsterWhichShoots=None
      self.playerWhenMonsterShoots=-1

    return 0

  def looseOneLife(self,name):
    self.sndSourceMonsterFire.source_callback=None
    self.lives-=1
    if self.lives!=0: 
      self.status=4
      self.reInitLevel()
      self.playIntro()
    else:
      self.suspendCallbacks()
      self.gameOver()

  #-- Level management -------------------------------------------------

  def suspendCallbacks (self):
    self.setCallback('_Fire',None)
    self.setCallback('_Esc',None)
    self.BSCORE.validate_callback = None


  def levelCompleted(self):
    self.status=6
    self.suspendLoop()
    self.suspendCallbacks()

    self.sndSourceMessages.empty()
    msgtosay=0
    
    if self.level.bonusLevel==0:
      if self.timeBonus>0:
        self.addToScore(self.timeBonus,'B')
        self.sndSourceMessages.queue('timebonus')
        for mot in self.getSentenceToSay(self.timeBonus):
          self.sndSourceMessages.queue(mot)
        msgtosay+=1
    else:
      self.sndSourceMessages.queue('bonuslevelend')
      self.sndSourceMessages.queue('bonuslevelscore')
      for mot in self.getSentenceToSay(self.score_level):
        self.sndSourceMessages.queue(mot)
      msgtosay+=1
      
    if self.level.sonix!=None:
      self.sndSourceMessages.queue('intro_'+self.level.sonix)
      self.sndSourceMessages.queue(self.level.sonix)
      msgtosay+=1

    if msgtosay==0: self.levelCompleted2()
    else:
      self.sndSourceMessages.source_callback=self.levelCompleted2
      self.sndSourceMessages.play()

  def levelCompleted2(self,name=''):
    self.sndSourceMessages.source_callback=None

    if self.level.bonusLevel != 1:
      self.nbLevelsCompleted += 1

    if self.gameInfo.isLevelInListe(self.nbLevelsCompleted):

      if self.level.sonix != None:
        if self.nbLevelObjects >= 3:
          if   self.level.sonix=='sonix01': nextlevel='L5bonus'
          elif self.level.sonix=='sonix02': nextlevel='L10bonus'
          elif self.level.sonix=='sonix03': nextlevel='L15bonus'
          elif self.level.sonix=='sonix04': nextlevel='L20bonus'
          else:
            nextlevel = self.nbLevelsCompleted
        else:
          nextlevel = self.nbLevelsCompleted
        self.nbLevelObjects=0
      else:
        nextlevel = self.nbLevelsCompleted

      self.gameInfo.setLevelID(nextlevel)
      self.gameInfo.setScore(self.score)
      self.gameInfo.setLives(self.lives)
      self.gameInfo.setNbMonstersDefeated(self.nbMonstersDefeated)
      self.gameInfo.setNbLevelsCompleted(self.nbLevelsCompleted)
      self.gameInfo.setNbLevelObjects(self.nbLevelObjects)

      self.sndSources.clear()
      self.next=MainSc
      self.nextargs=[self.gameInfo]

    else:
      # Fin du jeu. Gagne !
      self.BTitle.state = 'victoryscreen'
      self.state = 'victoryscreen'
      self.sndSourceMessages.empty()
      self.sndSourceMessages.queue('speech_won')
      self.sndSourceMessages.queue('epilogue')
      self.sndSourceMessages.source_callback=self.gameOverWIN
      self.sndSourceMessages.play()

  #-- Game over --------------------------------------------------------
  
  def gameOver(self):
    self.status=5
    self.BTitle.state = 'lostscreen'
    self.state = 'lostscreen'
    self.sndSourceMessages.empty()
    self.sndSourceMessages.queue('events_lose')
    self.sndSourceMessages.queue('speech_lose')
    self.sndSourceMessages.queue('gs_points')
    self.sndSourceMessages.source_callback=self.gameOver2
    for mot in self.getSentenceToSay(self.score):
      self.sndSourceMessages.queue(mot)
    self.sndSourceMessages.play()

  def gameOver2(self,name):
    #Go to HighScore scene
    self.gameInfo.setScore(self.score)
    self.gameInfo.setNbMonstersDefeated(self.nbMonstersDefeated)
    self.gameInfo.setNbLevelsCompleted(self.nbLevelsCompleted)

    self.gameInfo.removeRescueFile()

    self.sndSources.clear()
    self.next = self.gameInfo.getScene('highscore')
    self.nextargs=[self.gameInfo]

  def gameOverWIN(self,name):
    self.score+=(self.lives*200)
    self.gameInfo.setScore(self.score)
    self.gameInfo.setNbMonstersDefeated(self.nbMonstersDefeated)
    self.gameInfo.setNbLevelsCompleted(self.nbLevelsCompleted)

    self.gameInfo.removeRescueFile()
    
    self.sndSources.clear()
    self.next = self.gameInfo.getScene('highscore')
    self.nextargs=[self.gameInfo]


  #-- ------------------------------------------------------------------
  def cbTimeLimit(self,name):
    #self.suspendLoop()
    self.status=5

    self.sndSourceMessages.empty()
#    self.sndSourceMessages.queue('lose')
    self.sndSourceMessages.source_callback=self.gameOver2
    for mot in self.getSentenceToSay(self.score):
      self.sndSourceMessages.queue(mot)
    self.sndSourceMessages.play()
    return 0
  
  #-- ------------------------------------------------------------------
  def cbStats (self,name, type, key):
    self.sndSourceMessages.empty()
#    self.sndSourceMessages.queue('gamestat')

    self.sndSourceMessages.queue('gs_points')
    phrase=self.getSentenceToSay(self.score)
    if phrase!=[]:
      for mot in phrase: self.sndSourceMessages.queue(mot)

    self.sndSourceMessages.queue('gs_monsterdefeat')
    phrase=self.getSentenceToSay(self.nbMonstersDefeated)
    if phrase!=[]:
      for mot in phrase: self.sndSourceMessages.queue(mot)

    self.sndSourceMessages.queue('gs_levelscomplete')
    phrase=self.getSentenceToSay(self.nbLevelsCompleted)
    if phrase!=[]:
      for mot in phrase: self.sndSourceMessages.queue(mot)

    self.sndSourceMessages.queue('gs_lives')
    phrase=self.getSentenceToSay(self.lives)
    if phrase!=[]:
      for mot in phrase: self.sndSourceMessages.queue(mot)

    self.sndSourceMessages.play()
    self._menustatus=1
    
    return 0

  #-- Update temporary visual displays ---------------------------------
  def updateDisplayMonsters(self):
    displayM=''
    for cell in self.monsterline:
      if cell==None: displayM+='_'
      else: displayM+=cell.repr
    if self.theBonus!=None:
      displayM=displayM[:self.theBonus.cpos]+self.theBonus.repr+displayM[self.theBonus.cpos+1:]
    self.BTMPZB.text='['+displayM+']'

  def updateDisplayPlayer(self):
    self.BTMPZA.text='['+'.'*self.player.position+'I'+(self.width-self.player.position-1)*'.'+']'

  #-- ------------------------------------------------------------------
