#!/usr/bin/python
# -*- coding: utf-8 -*-


from blindstation import *
from blindstation.utils import BSError

from math import pi, cos, sin #sqrt, pow



#-- ----------------------------------------------------

class BasePosition:

  def __init__(self, pos=[0.0,0.0,0.0], angle=90):
    ##> pos est un tableau a 3 valeurs reelles: [x,y,z]
    ##> angle est un entier, en degres
    self.setPosition(pos)
    self.setAngle(angle)

  def setPosition(self, pos):
    ##> jPos est la position x,y,z dans le referentiel du jeu
    ##> oPos est la position transposee dans le referentiel correspondant a OpenAL
    self.jPos = pos
    self.oPos = [-pos[0]*1.0,pos[2]*1.0,pos[1]*1.0]

  def setAngle(self, angle):
    self.jAngle = angle
    self.oAngle = pi * angle / 180

  def X(self): return self.jPos[0]
  def Y(self): return self.jPos[1]
  def Z(self): return self.jPos[2]


#-- ----------------------------------------------------

class PlayerBase(BasePosition,Listener):
  def __init__(self):
    Listener.__init__(self)
    BasePosition.__init__(self) #,pos=[0.0,0.0,0.0], angle=90)
    #self.setPosition(pos) pas utile, fait dans l'init de Entite
    #self.setAngle(angle)
    
  def setPosition(self, pos):
    BasePosition.setPosition(self, pos)
    Listener.setPosition(self, self.oPos[0],self.oPos[1], self.oPos[2])

  def setAngle(self, angle):
    BasePosition.setAngle(self, angle)
    Listener.setOrientation(self, -cos(self.oAngle), 0.0, sin(self.oAngle), 0.0, 1.0, 0.0);

#-- ----------------------------------------------------

class myMenu (Scene):

  def __init__(self, parent, name, state):
    Scene.__init__(self, parent, name, state)
    self.sndSourceMessages = Source(self, 'Messages')
  
    self._menustatus=0
    # self._menustatus=0: initialisation
    # self._menustatus=1: ready, waiting for selection
    # self._menustatus=2: selection performed, waiting for execution of callback
    # self._menustatus=3: move top, wait for bottom/top sound finished

    #self.sndSource=sndSource
    
    self.Liste={}
    self.Order=[]
    self.Callback={}
    self.SpecificSound={}
    self.Voices={}

    self.ticksound=None
    self.launchsound=None
    self.topsound=None
    self.bottomsound=None

    # Navigator
    self.navig = Navigator(self)
    self.navig.navigator_callback = self.navigator_callback
    self.navig.repeat = 200
    self.navig.key = KeyCode.RETURN

    self._menustatus=1
    
  def setTopBottomSounds(self,top,bottom=None):
    self.topsound=top
    if bottom==None: self.bottomsound=top
    else:            self.bottomsound=bottom
  
  def setTickSound(self,sndname):
    self.ticksound=sndname
  
  def setLaunchSound(self,sndname):
    self.launchsound=sndname

  def setCallback(self,name,cbName):
    if cbName!=None:
      self.Liste[name].validate_callback=self.selectMenuItem
      self.Callback[name]=cbName
    else:
      self.Liste[name].validate_callback=None
      if self.Callback.has_key(name):
        del self.Callback[name]

  def addMenuItem(self,name,state,cb=None,sndFile=None,voiceFile=None,pos=-1):
    self.Liste[name]=Widget(self,name,state)
    self.Liste[name].focus_callback=self.cbGrabFocusMenu
    
    if pos==-1: self.Order.append(name) # Ajouter en dernier
    else: self.Order.insert(pos,name)
    
    if cb!=None:
      self.Liste[name].validate_callback=self.selectMenuItem
      self.Callback[name]=cb

    if sndFile!=None:
      self.SpecificSound[name]=sndFile

    if voiceFile!=None:
      self.Voices[name]=voiceFile


  def menuButton(self,name): return self.Liste[name]

  def cbGrabFocusMenu(self,name):
    canplay=0
    self.sndSourceMessages.empty()
    self.sndSourceMessages.source_callback=None

    if self.ticksound!=None:
      self.sndSourceMessages.queue(self.ticksound)
      canplay=1

    if self.Voices.has_key(name):
      if type(self.Voices[name]) == type([]):
        for voice in self.Voices[name]:
          self.sndSourceMessages.queue(voice)
      else:
        self.sndSourceMessages.queue(self.Voices[name])
      canplay=1

    if canplay==1:
      self.sndSourceMessages.play()

  def findFocusIndex(self,nm):
    return self.Liste[nm].__id__

  def navigator_callback(self,dir):
    if self._menustatus==1:
      #print dir.x, dir.y

      if len(self.Order)>0:

#        if dir >= Navigator.BUTTON:
#          pass
#          for m in self.Order:
#            if self.Liste[m].hasFocus(): return self.selectMenuItem(m)
    
#        elif dir==Navigator.UP or dir==Navigator.LEFT: d=-1
#        elif dir==Navigator.DOWN or dir==Navigator.RIGHT: d=1

        if dir.y>0: d=-1
        elif dir.y<0: d=1
        elif dir.x>0: d=1
        elif dir.x<0: d=-1
        else: d=0

        if d!=0:
          if self.get_focus().name in self.Order:
            idx=self.Order.index(self.get_focus().name)
            self.nextfocus=idx+d
  
            if self.nextfocus>=0 and self.nextfocus<len(self.Order):
              self.set_focus(self.findFocusIndex(self.Order[self.nextfocus]))
            else:
              self.nextfocus=self.nextfocus%len(self.Order)
              
              if self.nextfocus==0 and self.bottomsound!=None:
                self._menustatus=3
                self.sndSourceMessages.empty()
                self.sndSourceMessages.queue(self.bottomsound)
                self.sndSourceMessages.source_callback=self.cbTopBottomSounds
                self.sndSourceMessages.play()
              elif self.nextfocus==len(self.Order)-1 and self.topsound!=None:
                self._menustatus=3
                self.sndSourceMessages.empty()
                self.sndSourceMessages.queue(self.topsound)
                self.sndSourceMessages.source_callback=self.cbTopBottomSounds
                self.sndSourceMessages.play()
  
          else:
            if d==1: self.nextfocus=0
            else:    self.nextfocus=len(self.Order)-1
            self.set_focus(self.findFocusIndex(self.Order[self.nextfocus]))
        

  def cbTopBottomSounds(self,name):
    self.set_focus(self.findFocusIndex(self.Order[self.nextfocus]))
    self._menustatus=1
    return 0

  def shoot_callback(self,name, type, key):
    return self.selectMenuItem(self.get_focus().name,type,key)

  def zoom_callback (self, name, type, key):
    self.zoom_mode = not self.zoom_mode

  def selectMenuItem(self, name, type, key):
    self._menustatus=2
    
    if self.Callback.has_key(name):
      self.selectedItem=name
      
      self.sndSourceMessages.empty()
      if self.SpecificSound.has_key(name):
        self.sndSourceMessages.queue(self.SpecificSound[name])
        self.sndSourceMessages.source_callback=self.launchCallback
        self.sndSourceMessages.play()

      elif self.launchsound!=None:
        self.sndSourceMessages.queue(self.launchsound)
        self.sndSourceMessages.source_callback=self.launchCallback
        self.sndSourceMessages.play()

      else:
        self.launchCallback(name)

  def launchCallback(self,name):
    #self.Callback[self.selectedItem](self.selectedItem,self.selectedItemType,self.selectedItemKey)
    return 0

  def removeMenuItem(self,name):
    if not name in self.Order: emergencyExit("Can't remove button: "+`name`)
    del self.Liste[name]
    if self.Callback.has_key(name): del self.Callback[name]
    if self.SpecificSound.has_key(name): del self.SpecificSound[name]
    self.Order.remove(name)

  def removeAllMenuItems(self):
    tmp=[x for x in self.Order]
    for item in tmp:
      self.removeMenuItem(item)

                
#-- ----------------------------------------------------
class sayNumbersClass:
  def __init__(self):
    
    self._words={}

    self._words['en']={}
    self._words['en'][0]=('zero','0EN')
    self._words['en'][1]=('one','one2')
    self._words['en'][2]=('two','two2')
    self._words['en'][3]=('three','three2')
    self._words['en'][4]=('four','four2')
    self._words['en'][5]=('five','five2')
    self._words['en'][6]=('six','six2')
    self._words['en'][7]=('seven','seven2')
    self._words['en'][8]=('eight','eight2')
    self._words['en'][9]=('nine','nine2')
    self._words['en'][10]=('ten','ten2')
    self._words['en'][11]=('eleven','eleven2')
    self._words['en'][12]=('twelve','twelve2')
    self._words['en'][13]=('thirteen','thirteen2')
    self._words['en'][14]=('fourteen','fourteen2')
    self._words['en'][15]=('fifteen','fifteen2')
    self._words['en'][16]=('sixteen','sixteen2')
    self._words['en'][17]=('seventeen','seventeen2')
    self._words['en'][18]=('eighteen','eightteen2')
    self._words['en'][19]=('nineteen','nineteen2')
    self._words['en'][20]=('twenty','twenty2')
    self._words['en'][30]=('thirty','thirty2')
    self._words['en'][40]=('forty','fourty2')
    self._words['en'][50]=('fifty','fifty2')
    self._words['en'][60]=('sixty','sixty2')
    self._words['en'][70]=('seventy','seventy2')
    self._words['en'][80]=('eighty','eighty2')
    self._words['en'][90]=('ninety','ninety2')
    self._words['en'][100]=('hundred','hundred2')
    self._words['en'][1000]=('thousand','thousend2')
    self._words['en']['et']=('and','and2')

    self._words['fr']={}
    self._words['fr'][0]=('zero','0')
    self._words['fr'][1]=('un','1')
    self._words['fr'][2]=('deux','2')
    self._words['fr'][3]=('trois','3')
    self._words['fr'][4]=('quatre','4')
    self._words['fr'][5]=('cinq','5')
    self._words['fr'][6]=('six','6')
    self._words['fr'][7]=('sept','7')
    self._words['fr'][8]=('huit','8(huite)')
    self._words['fr'][9]=('neuf','9')
    self._words['fr'][10]=('dix','10')
    self._words['fr'][11]=('onze','11')
    self._words['fr'][12]=('douze','12')
    self._words['fr'][13]=('treize','13')
    self._words['fr'][14]=('quatorze','14')
    self._words['fr'][15]=('quinze','15')
    self._words['fr'][16]=('seize','16')
    self._words['fr'][20]=('vingt','20(vinte)')
    self._words['fr'][30]=('trente','30')
    self._words['fr'][40]=('quarante','40')
    self._words['fr'][50]=('cinquante','50')
    self._words['fr'][60]=('soixante','60')
    self._words['fr'][80]=('quatre-vingt','80')
    self._words['fr'][100]=('cent','100')
    self._words['fr'][1000]=('mille','1000')
    self._words['fr']['et']=('et','et')
    self._words['fr']['6b']=('six','6(si)')
    self._words['fr']['8b']=('huit','8(hui)')
    self._words['fr']['20b']=('vingt','20(vin)')

    self._words['sv']={}
    self._words['sv'][0]=('noll','0SW')
    self._words['sv'][1]=('ett','onesw')
    self._words['sv'][2]=('tv','twosw')
    self._words['sv'][3]=('tre','threesw')
    self._words['sv'][4]=('fyra','foursw')
    self._words['sv'][5]=('fem','fivesw')
    self._words['sv'][6]=('sex','sixsw')
    self._words['sv'][7]=('sju','sevensw')
    self._words['sv'][8]=('tta','eightsw')
    self._words['sv'][9]=('nio','ninesw')
    self._words['sv'][10]=('tio','tensw')
    self._words['sv'][11]=('elva','elevensw')
    self._words['sv'][12]=('tolv','twelvesw')
    self._words['sv'][13]=('tretton','thirteensw')
    self._words['sv'][14]=('fjorton','fourteensw')
    self._words['sv'][15]=('femton','fifteensw')
    self._words['sv'][16]=('sexton','sixteensw')
    self._words['sv'][17]=('sjutton','seventeensw')
    self._words['sv'][18]=('arton','eightteensw')
    self._words['sv'][19]=('nitton','nineteensw')
    self._words['sv'][20]=('tjugo','twentysw')
    self._words['sv'][30]=('trettio','thirtysw')
    self._words['sv'][40]=('fyrtio','fortysw')
    self._words['sv'][50]=('femtio','fiftysw')
    self._words['sv'][60]=('sextio','sixtysw')
    self._words['sv'][70]=('sjuttio','seventysw')
    self._words['sv'][80]=('ttio','eightysw')
    self._words['sv'][90]=('nittio','ninetysw')
    self._words['sv'][100]=('hundra','hundredsw')
    self._words['sv'][1000]=('tusen','thousendsw')

    self.saylang=['fr','en','sv']
    self.availableLangs=['fr','en','sv']

#  def words(self,lang=None):
#    tmp=[]
#    if lang!=None: langues=[lang,]
#    else: langues=self.availableLangs
#    for l in langues:
#      for item in self._words[l].keys():
#        mot=self._words[l][item][1]
#        if mot!='': tmp.append(l+'/'+mot)
#    return tmp
    
  def tospeech1e6(self, nb,lang):
    if nb>=1000000: return 'overflow'
    m=nb/1000
    r=[]
    if nb==0: r.append(self._words[lang][0])
    else:
      if m>1 or (lang!='fr' and m==1): r.extend(self.tospeech1e3(m,lang))
      if m>=1: r.append(self._words[lang][1000])
      reste=nb%1000
      if lang=='en' and m>0 and reste!=0 and (reste<100 or reste%100==0): r.append(self._words[lang]['et'])
      r.extend(self.tospeech1e3(reste,lang))

    if lang=='fr':
      for i in range(len(r)-1):
        if r[i]==self._words[lang][6] and (r[i+1]==self._words[lang][100] or r[i+1]==self._words[lang][1000]):
          r[i]=self._words[lang]['6b']
        elif r[i]==self._words[lang][8] and (r[i+1]==self._words[lang][100] or r[i+1]==self._words[lang][1000]):
          r[i]=self._words[lang]['8b']

  
    return r
  
  def tospeech1e3(self,nb,lang):
    if nb>=1000: return 'overflow'
    c=(nb/100)%10
    d=(nb/10)%10
    u=nb%10
    d2=''
    
    if d>0:
      if d==1 or (lang=='fr' and d in [7,9]):
        if u!=0 and (lang!='fr' or u<7):
          d-=1
          u+=10
        else:
          d-=1
          d2=self._words[lang][10]
      elif lang=='fr' and u==1 and d!=8:
        d2=self._words[lang]['et']
      if lang=='fr' and d==6 and u==11:
        d2=self._words[lang]['et']
      
    r=[]
    if c>1 or (lang!='fr' and c==1): r.extend([self._words[lang][c],self._words[lang][100]])
    elif c==1: r.append(self._words[lang][100])
    #print c,d, u,d2
    if (lang=='en' and c>0 and (d>0 or u>0 or d2==self._words[lang][10])): r.append(self._words[lang]['et'])
    
    if d>0: r.append(self._words[lang][d*10])#was d-1
    if d2!='': r.append(d2)
    if u>0: r.append(self._words[lang][u])
  
    if lang=='fr' and len(r)>0:
      if r[-1]==self._words[lang][20]:
        r[-1]=self._words[lang]['20b']
    return r

#-- ----------------------------------------------------
